/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;
import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.PlusMult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DenseVector
extends AbstractVector {
    private double[] values;

    public DenseVector() {
        super(0);
    }

    public DenseVector(double[] values) {
        this(values, false);
    }

    public DenseVector(double[] values, boolean shallowCopy) {
        super(values.length);
        this.values = shallowCopy ? values : (double[])values.clone();
    }

    public DenseVector(DenseVector values, boolean shallowCopy) {
        this(values.values, shallowCopy);
    }

    public DenseVector(int cardinality) {
        super(cardinality);
        this.values = new double[cardinality];
    }

    public DenseVector(Vector vector) {
        super(vector.size());
        this.values = new double[vector.size()];
        Iterator<Vector.Element> it = vector.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            this.values[e.index()] = e.get();
        }
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return new DenseMatrix(rows, columns);
    }

    @Override
    public DenseVector clone() {
        return new DenseVector((double[])this.values.clone());
    }

    @Override
    public boolean isDense() {
        return true;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double dotSelf() {
        double result = 0.0;
        int max = this.size();
        for (int i = 0; i < max; ++i) {
            double value = this.getQuick(i);
            result += value * value;
        }
        return result;
    }

    @Override
    public double getQuick(int index) {
        return this.values[index];
    }

    @Override
    public DenseVector like() {
        return new DenseVector(this.size());
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values[index] = value;
    }

    @Override
    public Vector assign(double value) {
        this.lengthSquared = -1.0;
        Arrays.fill(this.values, value);
        return this;
    }

    @Override
    public Vector assign(Vector other, BinaryFunction function) {
        if (this.size() != other.size()) {
            throw new CardinalityException(this.size(), other.size());
        }
        if (function instanceof PlusMult) {
            Vector.Element e;
            Iterator<Vector.Element> it = other.iterateNonZero();
            while (it.hasNext() && (e = it.next()) != null) {
                this.values[e.index()] = function.apply(this.values[e.index()], e.get());
            }
        } else {
            for (int i = 0; i < this.size(); ++i) {
                this.values[i] = function.apply(this.values[i], other.getQuick(i));
            }
        }
        this.lengthSquared = -1.0;
        return this;
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.length;
    }

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size());
        }
        if (offset + length > this.size()) {
            throw new IndexException(offset + length, this.size());
        }
        return new VectorView(this, offset, length);
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DenseVector) {
            return Arrays.equals(this.values, ((DenseVector)o).values);
        }
        return super.equals(o);
    }

    @Override
    public double getLengthSquared() {
        if (this.lengthSquared >= 0.0) {
            return this.lengthSquared;
        }
        double result = 0.0;
        for (double value : this.values) {
            result += value * value;
        }
        this.lengthSquared = result;
        return result;
    }

    @Override
    public void addTo(Vector v) {
        if (this.size() != v.size()) {
            throw new CardinalityException(this.size(), v.size());
        }
        for (int i = 0; i < this.values.length; ++i) {
            v.setQuick(i, this.values[i] + v.getQuick(i));
        }
    }

    public void addAll(Vector v) {
        if (this.size() != v.size()) {
            throw new CardinalityException(this.size(), v.size());
        }
        Iterator<Vector.Element> iter = v.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            int n = element.index();
            this.values[n] = this.values[n] + element.get();
        }
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        double result = 0.0;
        if (x instanceof DenseVector) {
            for (int i = 0; i < x.size(); ++i) {
                result += this.values[i] * x.getQuick(i);
            }
            return result;
        }
        Iterator<Vector.Element> iter = x.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * this.values[element.index()];
        }
        return result;
    }

    private final class DenseElement
    implements Vector.Element {
        int index;

        private DenseElement() {
        }

        public double get() {
            return DenseVector.this.values[this.index];
        }

        public int index() {
            return this.index;
        }

        public void set(double value) {
            DenseVector.this.lengthSquared = -1.0;
            ((DenseVector)DenseVector.this).values[this.index] = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AllIterator
    implements Iterator<Vector.Element> {
        private final DenseElement element;

        private AllIterator() {
            this.element = new DenseElement();
            this.element.index = -1;
        }

        @Override
        public boolean hasNext() {
            return this.element.index + 1 < DenseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (this.element.index + 1 >= DenseVector.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.element.index;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NonDefaultIterator
    implements Iterator<Vector.Element> {
        private final DenseElement element;
        private int index;

        private NonDefaultIterator() {
            this.element = new DenseElement();
            this.index = 0;
            this.goToNext();
        }

        private void goToNext() {
            while (this.index < DenseVector.this.size() && DenseVector.this.values[this.index] == 0.0) {
                ++this.index;
            }
        }

        @Override
        public boolean hasNext() {
            return this.index < DenseVector.this.size();
        }

        @Override
        public Vector.Element next() {
            if (this.index >= DenseVector.this.size()) {
                throw new NoSuchElementException();
            }
            this.element.index = this.index++;
            this.goToNext();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

