/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.Matrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonMatrixAdapter
implements JsonSerializer<Matrix>,
JsonDeserializer<Matrix> {
    public static final String CLASS = "class";
    public static final String MATRIX = "matrix";

    public JsonElement serialize(Matrix src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.add(CLASS, (JsonElement)new JsonPrimitive(src.getClass().getName()));
        obj.add(MATRIX, context.serialize((Object)src));
        return obj;
    }

    public Matrix deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        Class<?> cl;
        JsonObject obj = json.getAsJsonObject();
        String klass = obj.get(CLASS).getAsString();
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            cl = ccl.loadClass(klass);
        }
        catch (ClassNotFoundException e) {
            throw new JsonParseException((Throwable)e);
        }
        if (obj.get(MATRIX).isJsonPrimitive()) {
            String matrix = obj.get(MATRIX).getAsString();
            Gson gson = AbstractMatrix.gson();
            return (Matrix)gson.fromJson(matrix, cl);
        }
        return (Matrix)context.deserialize(obj.get(MATRIX), cl);
    }
}

