/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorView;

public class MatrixView
extends AbstractMatrix {
    private Matrix matrix;
    private int[] offset;

    private MatrixView() {
    }

    public MatrixView(Matrix matrix, int[] offset, int[] size) {
        int rowOffset = offset[0];
        if (rowOffset < 0) {
            throw new IndexException(rowOffset, this.rowSize());
        }
        int rowsRequested = size[0];
        if (rowOffset + rowsRequested > matrix.rowSize()) {
            throw new IndexException(rowOffset + rowsRequested, matrix.rowSize());
        }
        int columnOffset = offset[1];
        if (columnOffset < 0) {
            throw new IndexException(columnOffset, this.columnSize());
        }
        int columnsRequested = size[1];
        if (columnOffset + columnsRequested > matrix.columnSize()) {
            throw new IndexException(columnOffset + columnsRequested, matrix.columnSize());
        }
        this.matrix = matrix;
        this.offset = offset;
        this.cardinality = Arrays.copyOf((int[])size, (int)2);
    }

    public Matrix clone() {
        MatrixView clone = (MatrixView)super.clone();
        clone.matrix = this.matrix.clone();
        clone.offset = (int[])this.offset.clone();
        clone.cardinality = (int[])this.cardinality.clone();
        return clone;
    }

    public double getQuick(int row, int column) {
        return this.matrix.getQuick(this.offset[0] + row, this.offset[1] + column);
    }

    public Matrix like() {
        return this.matrix.like(this.rowSize(), this.columnSize());
    }

    public Matrix like(int rows, int columns) {
        return this.matrix.like(rows, columns);
    }

    public void setQuick(int row, int column, double value) {
        this.matrix.setQuick(this.offset[0] + row, this.offset[1] + column, value);
    }

    public int[] getNumNondefaultElements() {
        return this.cardinality;
    }

    public Matrix viewPart(int[] offset, int[] size) {
        if (offset[0] < 0) {
            throw new IndexException(offset[0], 0);
        }
        if (offset[0] + size[0] > this.rowSize()) {
            throw new IndexException(offset[0] + size[0], this.rowSize());
        }
        if (offset[1] < 0) {
            throw new IndexException(offset[1], 0);
        }
        if (offset[1] + size[1] > this.columnSize()) {
            throw new IndexException(offset[1] + size[1], this.columnSize());
        }
        int[] origin = (int[])offset.clone();
        origin[0] = origin[0] + offset[0];
        origin[1] = origin[1] + offset[1];
        return new MatrixView(this.matrix, origin, size);
    }

    public Matrix assignColumn(int column, Vector other) {
        if (this.rowSize() != other.size()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        for (int row = 0; row < this.rowSize(); ++row) {
            this.matrix.setQuick(row + this.offset[0], column + this.offset[1], other.getQuick(row));
        }
        return this;
    }

    public Matrix assignRow(int row, Vector other) {
        if (this.columnSize() != other.size()) {
            throw new CardinalityException(this.columnSize(), other.size());
        }
        for (int col = 0; col < this.columnSize(); ++col) {
            this.matrix.setQuick(row + this.offset[0], col + this.offset[1], other.getQuick(col));
        }
        return this;
    }

    public Vector getColumn(int column) {
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        return new VectorView(this.matrix.getColumn(column + this.offset[1]), this.offset[0], this.rowSize());
    }

    public Vector getRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        return new VectorView(this.matrix.getRow(row + this.offset[0]), this.offset[1], this.columnSize());
    }
}

