/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.io.Serializable;

final class OrderedIntDoubleMapping
implements Serializable,
Cloneable {
    static final double DEFAULT_VALUE = 0.0;
    private int[] indices;
    private double[] values;
    private int numMappings;

    OrderedIntDoubleMapping() {
        this(11);
    }

    OrderedIntDoubleMapping(int capacity) {
        this.indices = new int[capacity];
        this.values = new double[capacity];
        this.numMappings = 0;
    }

    private OrderedIntDoubleMapping(int[] indices, double[] values, int numMappings) {
        this.indices = indices;
        this.values = values;
        this.numMappings = numMappings;
    }

    int[] getIndices() {
        return this.indices;
    }

    double[] getValues() {
        return this.values;
    }

    int getNumMappings() {
        return this.numMappings;
    }

    private void growTo(int newCapacity) {
        if (newCapacity > this.indices.length) {
            int[] newIndices = new int[newCapacity];
            System.arraycopy(this.indices, 0, newIndices, 0, this.numMappings);
            this.indices = newIndices;
            double[] newValues = new double[newCapacity];
            System.arraycopy(this.values, 0, newValues, 0, this.numMappings);
            this.values = newValues;
        }
    }

    private int find(int index) {
        int low = 0;
        int high = this.numMappings - 1;
        while (low <= high) {
            int mid = low + (high - low >>> 1);
            int midVal = this.indices[mid];
            if (midVal < index) {
                low = mid + 1;
                continue;
            }
            if (midVal > index) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public double get(int index) {
        int offset = this.find(index);
        return offset >= 0 ? this.values[offset] : 0.0;
    }

    public void set(int index, double value) {
        int offset = this.find(index);
        if (offset >= 0) {
            if (value == 0.0) {
                int i = offset + 1;
                int j = offset;
                while (i < this.numMappings) {
                    this.indices[j] = this.indices[i];
                    this.values[j] = this.values[i];
                    ++i;
                    ++j;
                }
                --this.numMappings;
            } else {
                this.values[offset] = value;
            }
        } else if (value != 0.0) {
            int at;
            if (this.numMappings >= this.indices.length) {
                this.growTo(Math.max((int)(1.2 * (double)this.numMappings), this.numMappings + 1));
            }
            if (this.numMappings > (at = -offset - 1)) {
                int i = this.numMappings - 1;
                int j = this.numMappings;
                while (i >= at) {
                    this.indices[j] = this.indices[i];
                    this.values[j] = this.values[i];
                    --i;
                    --j;
                }
            }
            this.indices[at] = index;
            this.values[at] = value;
            ++this.numMappings;
        }
    }

    public int hashCode() {
        int result = 0;
        for (int i = 0; i < this.numMappings; ++i) {
            result = 31 * result + this.indices[i];
            result = 31 * result + (int)Double.doubleToRawLongBits(this.values[i]);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof OrderedIntDoubleMapping) {
            OrderedIntDoubleMapping other = (OrderedIntDoubleMapping)o;
            if (this.numMappings == other.numMappings) {
                for (int i = 0; i < this.numMappings; ++i) {
                    if (this.indices[i] == other.indices[i] && this.values[i] == other.values[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(10 * this.numMappings);
        for (int i = 0; i < this.numMappings; ++i) {
            result.append('(');
            result.append(this.indices[i]);
            result.append(',');
            result.append(this.values[i]);
            result.append(')');
        }
        return result.toString();
    }

    public OrderedIntDoubleMapping clone() {
        return new OrderedIntDoubleMapping((int[])this.indices.clone(), (double[])this.values.clone(), this.numMappings);
    }
}

