/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.ArrayList;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.VectorIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OrthonormalityVerifier {
    private OrthonormalityVerifier() {
    }

    public static VectorIterable pairwiseInnerProducts(Iterable<MatrixSlice> basis) {
        DenseMatrix out = null;
        for (MatrixSlice slice1 : basis) {
            ArrayList<Double> dots = new ArrayList<Double>();
            for (MatrixSlice slice2 : basis) {
                dots.add(slice1.vector().dot(slice2.vector()));
            }
            if (out == null) {
                out = new DenseMatrix(dots.size(), dots.size());
            }
            for (int i = 0; i < dots.size(); ++i) {
                out.set(slice1.index(), i, (double)((Double)dots.get(i)));
            }
        }
        return out;
    }
}

