/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialAccessSparseVector
extends AbstractVector {
    private OrderedIntDoubleMapping values;

    public SequentialAccessSparseVector() {
        super(0);
    }

    public SequentialAccessSparseVector(int cardinality) {
        this(cardinality, cardinality / 8);
    }

    public SequentialAccessSparseVector(int cardinality, int size) {
        super(cardinality);
        this.values = new OrderedIntDoubleMapping(size);
    }

    public SequentialAccessSparseVector(Vector other) {
        this(other.size(), other.getNumNondefaultElements());
        Vector.Element e;
        Iterator<Vector.Element> it = other.iterateNonZero();
        while (it.hasNext() && (e = it.next()) != null) {
            this.set(e.index(), e.get());
        }
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other, boolean shallowCopy) {
        super(other.size());
        this.values = shallowCopy ? other.values : other.values.clone();
    }

    public SequentialAccessSparseVector(SequentialAccessSparseVector other) {
        this(other.size(), other.getNumNondefaultElements());
        this.values = other.values.clone();
    }

    private SequentialAccessSparseVector(int cardinality, OrderedIntDoubleMapping values) {
        super(cardinality);
        this.values = values;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        int[] cardinality = new int[]{rows, columns};
        return new SparseRowMatrix(cardinality);
    }

    @Override
    public SequentialAccessSparseVector clone() {
        return new SequentialAccessSparseVector(this.size(), this.values.clone());
    }

    @Override
    public Vector assign(Vector other) {
        int size = this.size();
        if (size != other.size()) {
            throw new CardinalityException(size, other.size());
        }
        if (other instanceof SequentialAccessSparseVector) {
            this.values = ((SequentialAccessSparseVector)other).values.clone();
        } else {
            this.values = new OrderedIntDoubleMapping();
            Iterator<Vector.Element> othersElems = other.iterateNonZero();
            while (othersElems.hasNext()) {
                Vector.Element elem = othersElems.next();
                this.setQuick(elem.index(), elem.get());
            }
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('{');
        Iterator<Vector.Element> it = this.iterateNonZero();
        while (it.hasNext()) {
            Vector.Element e = it.next();
            result.append(e.index());
            result.append(':');
            result.append(e.get());
            result.append(',');
        }
        if (result.length() > 1) {
            result.setCharAt(result.length() - 1, '}');
        }
        return result.toString();
    }

    @Override
    public boolean isDense() {
        return false;
    }

    @Override
    public boolean isSequentialAccess() {
        return true;
    }

    @Override
    public double getQuick(int index) {
        return this.values.get(index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.lengthSquared = -1.0;
        this.values.set(index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.values.getNumMappings();
    }

    @Override
    public SequentialAccessSparseVector like() {
        return new SequentialAccessSparseVector(this.size(), this.values.getNumMappings());
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonDefaultIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        if (this == x) {
            return this.dotSelf();
        }
        if (x instanceof SequentialAccessSparseVector) {
            Iterator<Vector.Element> myIter = this.iterateNonZero();
            Iterator<Vector.Element> otherIter = x.iterateNonZero();
            if (!myIter.hasNext() || !otherIter.hasNext()) {
                return 0.0;
            }
            Vector.Element myCurrent = myIter.next();
            Vector.Element otherCurrent = otherIter.next();
            double result = 0.0;
            while (true) {
                int otherIndex;
                int myIndex;
                if ((myIndex = myCurrent.index()) == (otherIndex = otherCurrent.index())) {
                    result += myCurrent.get() * otherCurrent.get();
                }
                if (myIndex <= otherIndex) {
                    if (!myIter.hasNext()) break;
                    myCurrent = myIter.next();
                }
                if (myIndex < otherIndex) continue;
                if (!otherIter.hasNext()) break;
                otherCurrent = otherIter.next();
            }
            return result;
        }
        double result = 0.0;
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element element = iter.next();
            result += element.get() * x.getQuick(element.index());
        }
        return result;
    }

    @Override
    public Vector minus(Vector that) {
        if (this.size() != that.size()) {
            throw new CardinalityException(this.size(), that.size());
        }
        Vector result = that.clone();
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element thisElement = iter.next();
            int index = thisElement.index();
            result.setQuick(index, that.getQuick(index) - thisElement.get());
        }
        result.assign(Functions.NEGATE);
        return result;
    }

    private final class AllElement
    implements Vector.Element {
        private int index = -1;
        private int nextOffset;

        private AllElement() {
        }

        void advanceIndex() {
            ++this.index;
            if (this.index > SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                ++this.nextOffset;
            }
        }

        int getNextIndex() {
            return this.index + 1;
        }

        public double get() {
            if (this.index == SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                return SequentialAccessSparseVector.this.values.getValues()[this.nextOffset];
            }
            return 0.0;
        }

        public int index() {
            return this.index;
        }

        public void set(double value) {
            SequentialAccessSparseVector.this.lengthSquared = -1.0;
            if (this.index == SequentialAccessSparseVector.this.values.getIndices()[this.nextOffset]) {
                ((SequentialAccessSparseVector)SequentialAccessSparseVector.this).values.getValues()[this.nextOffset] = value;
            } else {
                SequentialAccessSparseVector.this.values.set(this.index, value);
            }
        }
    }

    private final class NonDefaultElement
    implements Vector.Element {
        private int offset = -1;

        private NonDefaultElement() {
        }

        void advanceOffset() {
            ++this.offset;
        }

        int getNextOffset() {
            return this.offset + 1;
        }

        public double get() {
            return SequentialAccessSparseVector.this.values.getValues()[this.offset];
        }

        public int index() {
            return SequentialAccessSparseVector.this.values.getIndices()[this.offset];
        }

        public void set(double value) {
            SequentialAccessSparseVector.this.lengthSquared = -1.0;
            ((SequentialAccessSparseVector)SequentialAccessSparseVector.this).values.getValues()[this.offset] = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AllIterator
    implements Iterator<Vector.Element> {
        private final AllElement element;

        private AllIterator() {
            this.element = new AllElement();
        }

        @Override
        public boolean hasNext() {
            int numMappings = SequentialAccessSparseVector.this.values.getNumMappings();
            return numMappings > 0 && this.element.getNextIndex() <= SequentialAccessSparseVector.this.values.getIndices()[numMappings - 1];
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.advanceIndex();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NonDefaultIterator
    implements Iterator<Vector.Element> {
        private final NonDefaultElement element;

        private NonDefaultIterator() {
            this.element = new NonDefaultElement();
        }

        @Override
        public boolean hasNext() {
            int numMappings = SequentialAccessSparseVector.this.values.getNumMappings();
            return numMappings > 0 && this.element.getNextOffset() < numMappings;
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.element.advanceOffset();
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

