/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VectorView
extends AbstractVector {
    private Vector vector;
    private int offset;

    public VectorView() {
        super(0);
    }

    public VectorView(Vector vector, int offset, int cardinality) {
        super(cardinality);
        this.vector = vector;
        this.offset = offset;
    }

    @Override
    protected Matrix matrixLike(int rows, int columns) {
        return ((AbstractVector)this.vector).matrixLike(rows, columns);
    }

    @Override
    public Vector clone() {
        VectorView r = (VectorView)super.clone();
        r.vector = this.vector.clone();
        r.offset = this.offset;
        return r;
    }

    @Override
    public boolean isDense() {
        return this.vector.isDense();
    }

    @Override
    public boolean isSequentialAccess() {
        return this.vector.isSequentialAccess();
    }

    @Override
    public VectorView like() {
        return new VectorView(this.vector.like(), this.offset, this.size());
    }

    @Override
    public double getQuick(int index) {
        return this.vector.getQuick(this.offset + index);
    }

    @Override
    public void setQuick(int index, double value) {
        this.vector.setQuick(this.offset + index, value);
    }

    @Override
    public int getNumNondefaultElements() {
        return this.size();
    }

    @Override
    public Vector viewPart(int offset, int length) {
        if (offset < 0) {
            throw new IndexException(offset, this.size());
        }
        if (offset + length > this.size()) {
            throw new IndexException(offset + length, this.size());
        }
        return new VectorView(this.vector, offset + this.offset, length);
    }

    private boolean isInView(int index) {
        return index >= this.offset && index < this.offset + this.size();
    }

    @Override
    public Iterator<Vector.Element> iterateNonZero() {
        return new NonZeroIterator();
    }

    @Override
    public Iterator<Vector.Element> iterator() {
        return new AllIterator();
    }

    @Override
    public double dot(Vector x) {
        if (this.size() != x.size()) {
            throw new CardinalityException(this.size(), x.size());
        }
        double result = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.getQuick(i) * x.getQuick(i);
        }
        return result;
    }

    @Override
    public double getLengthSquared() {
        double result = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double value = this.getQuick(i);
            result += value * value;
        }
        return result;
    }

    @Override
    public double getDistanceSquared(Vector v) {
        double result = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            double delta = this.getQuick(i) - v.getQuick(i);
            result += delta * delta;
        }
        return result;
    }

    @Override
    public void addTo(Vector v) {
        Iterator<Vector.Element> iter = this.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element elt = iter.next();
            v.set(elt.index(), elt.get() + v.get(elt.index()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class AllIterator
    implements Iterator<Vector.Element> {
        private final Iterator<Vector.Element> it;
        private Vector.Element el;

        private AllIterator() {
            this.it = VectorView.this.vector.iterator();
            this.buffer();
        }

        private void buffer() {
            while (this.it.hasNext()) {
                this.el = this.it.next();
                if (!VectorView.this.isInView(this.el.index())) continue;
                final Vector.Element decorated = VectorView.this.vector.getElement(this.el.index());
                this.el = new Vector.Element(){

                    public double get() {
                        return decorated.get();
                    }

                    public int index() {
                        return decorated.index() - VectorView.this.offset;
                    }

                    public void set(double value) {
                        decorated.set(value);
                    }
                };
                return;
            }
            this.el = null;
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Vector.Element buffer = this.el;
            this.buffer();
            return buffer;
        }

        @Override
        public boolean hasNext() {
            return this.el != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class NonZeroIterator
    implements Iterator<Vector.Element> {
        private final Iterator<Vector.Element> it;
        private Vector.Element el;

        private NonZeroIterator() {
            this.it = VectorView.this.vector.iterateNonZero();
            this.buffer();
        }

        private void buffer() {
            while (this.it.hasNext()) {
                this.el = this.it.next();
                if (!VectorView.this.isInView(this.el.index()) || this.el.get() == 0.0) continue;
                final Vector.Element decorated = VectorView.this.vector.getElement(this.el.index());
                this.el = new Vector.Element(){

                    public double get() {
                        return decorated.get();
                    }

                    public int index() {
                        return decorated.index() - VectorView.this.offset;
                    }

                    public void set(double value) {
                        decorated.set(value);
                    }
                };
                return;
            }
            this.el = null;
        }

        @Override
        public Vector.Element next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Vector.Element buffer = this.el;
            this.buffer();
            return buffer;
        }

        @Override
        public boolean hasNext() {
            return this.el != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

