/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.lanczos;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.SparseRowMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DenseDoubleMatrix2D;
import org.apache.mahout.math.matrix.linalg.EigenvalueDecomposition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanczosSolver {
    private static final Logger log = LoggerFactory.getLogger(LanczosSolver.class);
    public static final double SAFE_MAX = 1.0E150;
    private static final double NANOS_IN_MILLI = 1000000.0;
    private final Map<TimingSection, Long> startTimes = new EnumMap<TimingSection, Long>(TimingSection.class);
    private final Map<TimingSection, Long> times = new EnumMap<TimingSection, Long>(TimingSection.class);
    protected double scaleFactor = 0.0;

    public void solve(VectorIterable corpus, int desiredRank, Matrix eigenVectors, List<Double> eigenValues) {
        this.solve(corpus, desiredRank, eigenVectors, eigenValues, false);
    }

    public void solve(VectorIterable corpus, int desiredRank, Matrix eigenVectors, List<Double> eigenValues, boolean isSymmetric) {
        log.info("Finding {} singular vectors of matrix with {} rows, via Lanczos", (Object)desiredRank, (Object)corpus.numRows());
        Vector currentVector = this.getInitialVector(corpus);
        Vector previousVector = new DenseVector(currentVector.size());
        SparseRowMatrix basis = new SparseRowMatrix(new int[]{desiredRank, corpus.numCols()});
        basis.assignRow(0, currentVector);
        double beta = 0.0;
        DenseDoubleMatrix2D triDiag = new DenseDoubleMatrix2D(desiredRank, desiredRank);
        for (int i = 1; i < desiredRank; ++i) {
            this.startTime(TimingSection.ITERATE);
            Vector nextVector = isSymmetric ? corpus.times(currentVector) : corpus.timesSquared(currentVector);
            log.info("{} passes through the corpus so far...", (Object)i);
            this.calculateScaleFactor(nextVector);
            nextVector.assign(new Scale(1.0 / this.scaleFactor));
            nextVector.assign(previousVector, new PlusMult(-beta));
            double alpha = currentVector.dot(nextVector);
            nextVector.assign(currentVector, new PlusMult(-alpha));
            this.endTime(TimingSection.ITERATE);
            this.startTime(TimingSection.ORTHOGANLIZE);
            LanczosSolver.orthoganalizeAgainstAllButLast(nextVector, basis);
            this.endTime(TimingSection.ORTHOGANLIZE);
            beta = nextVector.norm(2.0);
            if (LanczosSolver.outOfRange(beta) || LanczosSolver.outOfRange(alpha)) {
                log.warn("Lanczos parameters out of range: alpha = {}, beta = {}.  Bailing out early!", (Object)alpha, (Object)beta);
                break;
            }
            nextVector.assign(new Scale(1.0 / beta));
            basis.assignRow(i, nextVector);
            previousVector = currentVector;
            currentVector = nextVector;
            triDiag.set(i - 1, i - 1, alpha);
            if (i >= desiredRank - 1) continue;
            triDiag.set(i - 1, i, beta);
            triDiag.set(i, i - 1, beta);
        }
        this.startTime(TimingSection.TRIDIAG_DECOMP);
        log.info("Lanczos iteration complete - now to diagonalize the tri-diagonal auxiliary matrix.");
        EigenvalueDecomposition decomp = new EigenvalueDecomposition(triDiag);
        DoubleMatrix2D eigenVects = decomp.getV();
        DoubleMatrix1D eigenVals = decomp.getRealEigenvalues();
        this.endTime(TimingSection.TRIDIAG_DECOMP);
        this.startTime(TimingSection.FINAL_EIGEN_CREATE);
        for (int i = 0; i < basis.numRows() - 1; ++i) {
            Vector realEigen = new DenseVector(corpus.numCols());
            DoubleMatrix1D ejCol = eigenVects.viewColumn(basis.numRows() - i - 1);
            for (int j = 0; j < ejCol.size(); ++j) {
                double d = ejCol.getQuick(j);
                realEigen.assign(basis.getRow(j), new PlusMult(d));
            }
            realEigen = realEigen.normalize();
            eigenVectors.assignRow(i, realEigen);
            log.info("Eigenvector {} found with eigenvalue {}", (Object)i, (Object)eigenVals.get(i));
            eigenValues.add(eigenVals.get(i));
        }
        log.info("LanczosSolver finished.");
        this.endTime(TimingSection.FINAL_EIGEN_CREATE);
    }

    protected void calculateScaleFactor(Vector nextVector) {
        if (this.scaleFactor == 0.0) {
            this.scaleFactor = nextVector.norm(2.0);
        }
    }

    private static boolean outOfRange(double d) {
        return Double.isNaN(d) || d > 1.0E150 || -d > 1.0E150;
    }

    private static void orthoganalizeAgainstAllButLast(Vector nextVector, Matrix basis) {
        for (int i = 0; i < basis.numRows() - 1; ++i) {
            double alpha;
            if (basis.getRow(i) == null || (alpha = nextVector.dot(basis.getRow(i))) == 0.0) continue;
            nextVector.assign(basis.getRow(i), new PlusMult(-alpha));
        }
    }

    protected Vector getInitialVector(VectorIterable corpus) {
        Vector v = null;
        for (MatrixSlice slice : corpus) {
            Vector vector;
            if (slice == null || (vector = slice.vector()) == null || vector.getLengthSquared() == 0.0) continue;
            this.scaleFactor += vector.getLengthSquared();
            if (v == null) {
                v = new DenseVector(vector.size()).plus(vector);
                continue;
            }
            v.assign(vector, Functions.PLUS);
        }
        v.assign(Functions.div(v.norm(2.0)));
        return v;
    }

    private void startTime(TimingSection section) {
        this.startTimes.put(section, System.nanoTime());
    }

    private void endTime(TimingSection section) {
        if (!this.times.containsKey((Object)section)) {
            this.times.put(section, 0L);
        }
        this.times.put(section, this.times.get((Object)section) + (System.nanoTime() - this.startTimes.get((Object)section)));
    }

    public double getTimeMillis(TimingSection section) {
        return (double)this.times.get((Object)section).longValue() / 1000000.0;
    }

    private static final class Scale
    implements UnaryFunction {
        private final double d;

        private Scale(double d) {
            this.d = d;
        }

        public double apply(double arg1) {
            return arg1 * this.d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimingSection {
        ITERATE,
        ORTHOGANLIZE,
        TRIDIAG_DECOMP,
        FINAL_EIGEN_CREATE;

    }
}

