/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.function;

import java.util.Date;
import org.apache.mahout.math.function.BinaryFunction;
import org.apache.mahout.math.function.DoubleDoubleProcedure;
import org.apache.mahout.math.function.DoubleProcedure;
import org.apache.mahout.math.function.Mult;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.UnaryFunction;
import org.apache.mahout.math.jet.random.engine.MersenneTwister;

public final class Functions {
    public static final UnaryFunction ABS = new UnaryFunction(){

        public double apply(double a) {
            return Math.abs(a);
        }
    };
    public static final UnaryFunction ACOS = new UnaryFunction(){

        public double apply(double a) {
            return Math.acos(a);
        }
    };
    public static final UnaryFunction ASIN = new UnaryFunction(){

        public double apply(double a) {
            return Math.asin(a);
        }
    };
    public static final UnaryFunction ATAN = new UnaryFunction(){

        public double apply(double a) {
            return Math.atan(a);
        }
    };
    public static final UnaryFunction CEIL = new UnaryFunction(){

        public double apply(double a) {
            return Math.ceil(a);
        }
    };
    public static final UnaryFunction COS = new UnaryFunction(){

        public double apply(double a) {
            return Math.cos(a);
        }
    };
    public static final UnaryFunction EXP = new UnaryFunction(){

        public double apply(double a) {
            return Math.exp(a);
        }
    };
    public static final UnaryFunction FLOOR = new UnaryFunction(){

        public double apply(double a) {
            return Math.floor(a);
        }
    };
    public static final UnaryFunction IDENTITY = new UnaryFunction(){

        public double apply(double a) {
            return a;
        }
    };
    public static final UnaryFunction INV = new UnaryFunction(){

        public double apply(double a) {
            return 1.0 / a;
        }
    };
    public static final UnaryFunction LOGARITHM = new UnaryFunction(){

        public double apply(double a) {
            return Math.log(a);
        }
    };
    public static final UnaryFunction LOG2 = new UnaryFunction(){

        public double apply(double a) {
            return Math.log(a) * 1.4426950408889634;
        }
    };
    public static final UnaryFunction NEGATE = new UnaryFunction(){

        public double apply(double a) {
            return -a;
        }
    };
    public static final UnaryFunction RINT = new UnaryFunction(){

        public double apply(double a) {
            return Math.rint(a);
        }
    };
    public static final UnaryFunction SIGN = new UnaryFunction(){

        public double apply(double a) {
            return a < 0.0 ? -1.0 : (a > 0.0 ? 1.0 : 0.0);
        }
    };
    public static final UnaryFunction SIN = new UnaryFunction(){

        public double apply(double a) {
            return Math.sin(a);
        }
    };
    public static final UnaryFunction SQRT = new UnaryFunction(){

        public double apply(double a) {
            return Math.sqrt(a);
        }
    };
    public static final UnaryFunction SQUARE = new UnaryFunction(){

        public double apply(double a) {
            return a * a;
        }
    };
    public static final UnaryFunction TAN = new UnaryFunction(){

        public double apply(double a) {
            return Math.tan(a);
        }
    };
    public static final BinaryFunction ATAN2 = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.atan2(a, b);
        }
    };
    public static final BinaryFunction COMPARE = new BinaryFunction(){

        public double apply(double a, double b) {
            return a < b ? -1.0 : (a > b ? 1.0 : 0.0);
        }
    };
    public static final BinaryFunction DIV = new BinaryFunction(){

        public double apply(double a, double b) {
            return a / b;
        }
    };
    public static final BinaryFunction EQUALS = new BinaryFunction(){

        public double apply(double a, double b) {
            return a == b ? 1.0 : 0.0;
        }
    };
    public static final BinaryFunction GREATER = new BinaryFunction(){

        public double apply(double a, double b) {
            return a > b ? 1.0 : 0.0;
        }
    };
    public static final BinaryFunction IEEE_REMAINDER = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.IEEEremainder(a, b);
        }
    };
    public static final DoubleDoubleProcedure IS_EQUAL = new DoubleDoubleProcedure(){

        public boolean apply(double a, double b) {
            return a == b;
        }
    };
    public static final DoubleDoubleProcedure IS_LESS = new DoubleDoubleProcedure(){

        public boolean apply(double a, double b) {
            return a < b;
        }
    };
    public static final DoubleDoubleProcedure IS_GREATER = new DoubleDoubleProcedure(){

        public boolean apply(double a, double b) {
            return a > b;
        }
    };
    public static final BinaryFunction LESS = new BinaryFunction(){

        public double apply(double a, double b) {
            return a < b ? 1.0 : 0.0;
        }
    };
    public static final BinaryFunction LG = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.log(a) / Math.log(b);
        }
    };
    public static final BinaryFunction MAX = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.max(a, b);
        }
    };
    public static final BinaryFunction MIN = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.min(a, b);
        }
    };
    public static final BinaryFunction MINUS = Functions.plusMult(-1.0);
    public static final BinaryFunction MOD = new BinaryFunction(){

        public double apply(double a, double b) {
            return a % b;
        }
    };
    public static final BinaryFunction MULT = new BinaryFunction(){

        public double apply(double a, double b) {
            return a * b;
        }
    };
    public static final BinaryFunction PLUS = new BinaryFunction(){

        public double apply(double a, double b) {
            return a + b;
        }
    };
    public static final BinaryFunction PLUS_ABS = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.abs(a) + Math.abs(b);
        }
    };
    public static final BinaryFunction POW = new BinaryFunction(){

        public double apply(double a, double b) {
            return Math.pow(a, b);
        }
    };

    private Functions() {
    }

    public static UnaryFunction between(final double from, final double to) {
        return new UnaryFunction(){

            public double apply(double a) {
                return from <= a && a <= to ? 1.0 : 0.0;
            }
        };
    }

    public static UnaryFunction bindArg1(final BinaryFunction function, final double c) {
        return new UnaryFunction(){

            public double apply(double var) {
                return function.apply(c, var);
            }
        };
    }

    public static UnaryFunction bindArg2(final BinaryFunction function, final double c) {
        return new UnaryFunction(){

            public double apply(double var) {
                return function.apply(var, c);
            }
        };
    }

    public static BinaryFunction chain(final BinaryFunction f, final UnaryFunction g, final UnaryFunction h) {
        return new BinaryFunction(){

            public double apply(double a, double b) {
                return f.apply(g.apply(a), h.apply(b));
            }
        };
    }

    public static BinaryFunction chain(final UnaryFunction g, final BinaryFunction h) {
        return new BinaryFunction(){

            public double apply(double a, double b) {
                return g.apply(h.apply(a, b));
            }
        };
    }

    public static UnaryFunction chain(final UnaryFunction g, final UnaryFunction h) {
        return new UnaryFunction(){

            public double apply(double a) {
                return g.apply(h.apply(a));
            }
        };
    }

    public static UnaryFunction compare(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return a < b ? -1.0 : (a > b ? 1.0 : 0.0);
            }
        };
    }

    public static UnaryFunction constant(final double c) {
        return new UnaryFunction(){

            public double apply(double a) {
                return c;
            }
        };
    }

    public static UnaryFunction div(double b) {
        return Functions.mult(1.0 / b);
    }

    public static UnaryFunction equals(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return a == b ? 1.0 : 0.0;
            }
        };
    }

    public static UnaryFunction greater(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return a > b ? 1.0 : 0.0;
            }
        };
    }

    public static UnaryFunction IEEEremainder(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return Math.IEEEremainder(a, b);
            }
        };
    }

    public static DoubleProcedure isBetween(final double from, final double to) {
        return new DoubleProcedure(){

            public boolean apply(double a) {
                return from <= a && a <= to;
            }
        };
    }

    public static DoubleProcedure isEqual(final double b) {
        return new DoubleProcedure(){

            public boolean apply(double a) {
                return a == b;
            }
        };
    }

    public static DoubleProcedure isGreater(final double b) {
        return new DoubleProcedure(){

            public boolean apply(double a) {
                return a > b;
            }
        };
    }

    public static DoubleProcedure isLess(final double b) {
        return new DoubleProcedure(){

            public boolean apply(double a) {
                return a < b;
            }
        };
    }

    public static UnaryFunction less(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return a < b ? 1.0 : 0.0;
            }
        };
    }

    public static UnaryFunction lg(final double b) {
        return new UnaryFunction(){
            private final double logInv;
            {
                this.logInv = 1.0 / Math.log(b);
            }

            public double apply(double a) {
                return Math.log(a) * this.logInv;
            }
        };
    }

    public static UnaryFunction max(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return Math.max(a, b);
            }
        };
    }

    public static UnaryFunction min(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return Math.min(a, b);
            }
        };
    }

    public static UnaryFunction minus(double b) {
        return Functions.plus(-b);
    }

    public static BinaryFunction minusMult(double constant) {
        return Functions.plusMult(-constant);
    }

    public static UnaryFunction mod(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return a % b;
            }
        };
    }

    public static UnaryFunction mult(double b) {
        return new Mult(b);
    }

    public static UnaryFunction plus(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return a + b;
            }
        };
    }

    public static BinaryFunction plusMult(double constant) {
        return new PlusMult(constant);
    }

    public static UnaryFunction pow(final double b) {
        return new UnaryFunction(){

            public double apply(double a) {
                return Math.pow(a, b);
            }
        };
    }

    public static UnaryFunction random() {
        return new MersenneTwister(new Date());
    }

    public static UnaryFunction round(final double precision) {
        return new UnaryFunction(){

            public double apply(double a) {
                return Math.rint(a / precision) * precision;
            }
        };
    }

    public static BinaryFunction swapArgs(final BinaryFunction function) {
        return new BinaryFunction(){

            public double apply(double a, double b) {
                return function.apply(b, a);
            }
        };
    }
}

