/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.function;

import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.VectorFunction;

public class VectorFunctions {
    private VectorFunctions() {
    }

    public static VectorFunction mean() {
        return new VectorFunction(){

            public double apply(Vector f) {
                return f.zSum() / (double)f.size();
            }
        };
    }

    public static VectorFunction sum() {
        return new VectorFunction(){

            public double apply(Vector f) {
                return f.zSum();
            }
        };
    }

    public static VectorFunction max() {
        return new VectorFunction(){

            public double apply(Vector f) {
                return f.aggregate(Functions.MAX, Functions.IDENTITY);
            }
        };
    }

    public static VectorFunction min() {
        return new VectorFunction(){

            public double apply(Vector f) {
                return f.aggregate(Functions.MIN, Functions.IDENTITY);
            }
        };
    }
}

