/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;

@Deprecated
public class BreitWigner
extends AbstractContinousDistribution {
    private double mean;
    private double gamma;
    private double cut;
    private static final BreitWigner shared = new BreitWigner(1.0, 0.2, 1.0, RandomUtils.getRandom());

    public BreitWigner(double mean, double gamma, double cut, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(mean, gamma, cut);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.gamma, this.cut);
    }

    public double nextDouble(double mean, double gamma, double cut) {
        if (gamma == 0.0) {
            return mean;
        }
        if (cut == Double.NEGATIVE_INFINITY) {
            double rval = 2.0 * this.randomGenerator.nextDouble() - 1.0;
            double displ = 0.5 * gamma * Math.tan(rval * 1.5707963267948966);
            return mean + displ;
        }
        double val = Math.atan(2.0 * cut / gamma);
        double rval = 2.0 * this.randomGenerator.nextDouble() - 1.0;
        double displ = 0.5 * gamma * Math.tan(rval * val);
        return mean + displ;
    }

    public void setState(double mean, double gamma, double cut) {
        this.mean = mean;
        this.gamma = gamma;
        this.cut = cut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double mean, double gamma, double cut) {
        BreitWigner breitWigner = shared;
        synchronized (breitWigner) {
            return shared.nextDouble(mean, gamma, cut);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.mean + ',' + this.gamma + ',' + this.cut + ')';
    }
}

