/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;
import org.apache.mahout.math.jet.random.Stack;

@Deprecated
public final class EmpiricalWalker
extends AbstractDiscreteDistribution {
    private int k;
    private int[] a;
    private double[] f;
    private double[] cdf;

    public EmpiricalWalker(double[] pdf, int interpolationType, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(pdf, interpolationType);
        this.setState2(pdf);
    }

    public double cdf(int k) {
        if (k < 0) {
            return 0.0;
        }
        if (k >= this.cdf.length - 1) {
            return 1.0;
        }
        return this.cdf[k];
    }

    public Object clone() {
        EmpiricalWalker copy = (EmpiricalWalker)super.clone();
        if (this.cdf != null) {
            copy.cdf = (double[])this.cdf.clone();
        }
        if (this.a != null) {
            copy.a = (int[])this.a.clone();
        }
        if (this.f != null) {
            copy.f = (double[])this.f.clone();
        }
        return copy;
    }

    public int nextInt() {
        double u = this.randomGenerator.nextDouble();
        int c = (int)(u *= (double)this.k);
        u -= (double)c;
        double f = this.f[c];
        if (f == 1.0) {
            return c;
        }
        return u < f ? c : this.a[c];
    }

    public double pdf(int k) {
        if (k < 0 || k >= this.cdf.length - 1) {
            return 0.0;
        }
        return this.cdf[k - 1] - this.cdf[k];
    }

    public void setState(double[] pdf, int interpolationType) {
        int i;
        if (pdf == null || pdf.length == 0) {
            throw new IllegalArgumentException("Non-existing pdf");
        }
        int nBins = pdf.length;
        this.cdf = new double[nBins + 1];
        this.cdf[0] = 0.0;
        for (i = 0; i < nBins; ++i) {
            if (pdf[i] < 0.0) {
                throw new IllegalArgumentException("Negative probability");
            }
            this.cdf[i + 1] = this.cdf[i] + pdf[i];
        }
        if (this.cdf[nBins] <= 0.0) {
            throw new IllegalArgumentException("At leat one probability must be > 0.0");
        }
        i = 0;
        while (i < nBins + 1) {
            int n = i++;
            this.cdf[n] = this.cdf[n] / this.cdf[nBins];
        }
    }

    public void setState2(double[] pdf) {
        int b;
        int k;
        int size = pdf.length;
        double pTotal = 0.0;
        for (k = 0; k < size; ++k) {
            pTotal += pdf[k];
        }
        this.k = size;
        this.f = new double[size];
        this.a = new int[size];
        double[] E = new double[size];
        for (k = 0; k < size; ++k) {
            E[k] = pdf[k] / pTotal;
        }
        double mean = 1.0 / (double)size;
        int nSmalls = 0;
        int nBigs = 0;
        for (k = 0; k < size; ++k) {
            if (E[k] < mean) {
                ++nSmalls;
                continue;
            }
            ++nBigs;
        }
        Stack bigs = new Stack(nBigs);
        Stack smalls = new Stack(nSmalls);
        for (k = 0; k < size; ++k) {
            if (E[k] < mean) {
                smalls.push(k);
                continue;
            }
            bigs.push(k);
        }
        while (smalls.size() > 0) {
            int s = smalls.pop();
            if (bigs.size() == 0) {
                this.a[s] = s;
                this.f[s] = 1.0;
                break;
            }
            this.a[s] = b = bigs.pop();
            this.f[s] = (double)size * E[s];
            double d = mean - E[s];
            int n = s;
            E[n] = E[n] + d;
            int n2 = b;
            E[n2] = E[n2] - d;
            if (E[b] < mean) {
                smalls.push(b);
                continue;
            }
            if (E[b] > mean) {
                bigs.push(b);
                continue;
            }
            this.a[b] = b;
            this.f[b] = 1.0;
        }
        while (bigs.size() > 0) {
            this.a[b] = b = bigs.pop();
            this.f[b] = 1.0;
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + (this.cdf != null ? this.cdf.length : 0) + ')';
    }
}

