/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Locale;
import java.util.Random;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;

public class Exponential
extends AbstractContinousDistribution {
    private double lambda;

    public Exponential(double lambda, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.lambda = lambda;
    }

    public double cdf(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x * this.lambda);
    }

    public double nextDouble() {
        return -Math.log(1.0 - this.randomGenerator.nextDouble()) / this.lambda;
    }

    public double pdf(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return this.lambda * Math.exp(-x * this.lambda);
    }

    public void setState(double lambda) {
        this.lambda = lambda;
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s(%.4f)", this.getClass().getName(), this.lambda);
    }
}

