/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;

@Deprecated
public class ExponentialPower
extends AbstractContinousDistribution {
    private static final ExponentialPower SHARED = new ExponentialPower(1.0, RandomUtils.getRandom());
    private double tau;
    private double s;
    private double sm1;
    private double tauSet = -1.0;

    public ExponentialPower(double tau, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(tau);
    }

    public double nextDouble() {
        return this.nextDouble(this.tau);
    }

    public double nextDouble(double tau) {
        double u;
        double x;
        double v;
        if (tau != this.tauSet) {
            this.s = 1.0 / tau;
            this.sm1 = 1.0 - this.s;
            this.tauSet = tau;
        }
        do {
            u = this.randomGenerator.nextDouble();
            u = 2.0 * u - 1.0;
            double u1 = Math.abs(u);
            v = this.randomGenerator.nextDouble();
            if (u1 <= this.sm1) {
                x = u1;
                continue;
            }
            double y = tau * (1.0 - u1);
            x = this.sm1 - this.s * Math.log(y);
            v *= y;
        } while (Math.log(v) > -Math.exp(Math.log(x) * tau));
        return u < 0.0 ? x : -x;
    }

    public void setState(double tau) {
        if (tau < 1.0) {
            throw new IllegalArgumentException();
        }
        this.tau = tau;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double tau) {
        ExponentialPower exponentialPower = SHARED;
        synchronized (exponentialPower) {
            return SHARED.nextDouble(tau);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.tau + ')';
    }
}

