/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import org.apache.mahout.math.jet.math.Arithmetic;

public final class Fun {
    private static final double[] B_0 = new double[]{-1.5787132, -0.6130827, 0.1735823, 1.4793411, 2.6667307, 4.9086836, 8.1355339};
    private static final double[] B_05 = new double[]{-1.9694802, -0.7642538, 0.0826017, 1.4276355, 2.6303682, 4.8857787, 8.1207968};
    private static final double[] B_1 = new double[]{-2.9807345, -1.1969943, -0.1843161, 1.2739241, 2.5218256, 4.8172216, 8.0765633};
    private static final double[] B_2 = new double[]{-5.9889676, -2.7145389, -1.1781269, 0.6782201, 2.0954009, 4.5452152, 7.9003173};
    private static final double[] B_3 = new double[]{-9.680344, -4.8211925, -2.6533185, -0.2583337, 1.4091915, 4.0993448, 7.608831};
    private static final double[] B_5 = new double[]{-18.1567152, -10.0939408, -6.5819139, -2.9371545, -0.6289005, 2.7270412, 6.6936799};
    private static final double[] B_8 = new double[]{-32.4910195, -19.6065943, -14.0347298, -8.3839439, -4.967973, -0.3567823, 4.5589697};

    private Fun() {
    }

    private static double fktValue(double lambda, double z1, double z2, double xValue) {
        return Math.cos(z1 * xValue) / Math.pow(xValue * xValue + z2 * z2, lambda + 0.5);
    }

    public static double bessel2Fkt(double lambda, double beta) {
        double newValue;
        int j;
        if (lambda == 0.0) {
            if (beta == 0.1) {
                return B_0[0];
            }
            if (beta == 0.5) {
                return B_0[1];
            }
            if (beta == 1.0) {
                return B_0[2];
            }
            if (beta == 2.0) {
                return B_0[3];
            }
            if (beta == 3.0) {
                return B_0[4];
            }
            if (beta == 5.0) {
                return B_0[5];
            }
            if (beta == 8.0) {
                return B_0[6];
            }
        }
        if (lambda == 0.5) {
            if (beta == 0.1) {
                return B_05[0];
            }
            if (beta == 0.5) {
                return B_05[1];
            }
            if (beta == 1.0) {
                return B_05[2];
            }
            if (beta == 2.0) {
                return B_05[3];
            }
            if (beta == 3.0) {
                return B_05[4];
            }
            if (beta == 5.0) {
                return B_05[5];
            }
            if (beta == 8.0) {
                return B_05[6];
            }
        }
        if (lambda == 1.0) {
            if (beta == 0.1) {
                return B_1[0];
            }
            if (beta == 0.5) {
                return B_1[1];
            }
            if (beta == 1.0) {
                return B_1[2];
            }
            if (beta == 2.0) {
                return B_1[3];
            }
            if (beta == 3.0) {
                return B_1[4];
            }
            if (beta == 5.0) {
                return B_1[5];
            }
            if (beta == 8.0) {
                return B_1[6];
            }
        }
        if (lambda == 2.0) {
            if (beta == 0.1) {
                return B_2[0];
            }
            if (beta == 0.5) {
                return B_2[1];
            }
            if (beta == 1.0) {
                return B_2[2];
            }
            if (beta == 2.0) {
                return B_2[3];
            }
            if (beta == 3.0) {
                return B_2[4];
            }
            if (beta == 5.0) {
                return B_2[5];
            }
            if (beta == 8.0) {
                return B_2[6];
            }
        }
        if (lambda == 3.0) {
            if (beta == 0.1) {
                return B_3[0];
            }
            if (beta == 0.5) {
                return B_3[1];
            }
            if (beta == 1.0) {
                return B_3[2];
            }
            if (beta == 2.0) {
                return B_3[3];
            }
            if (beta == 3.0) {
                return B_3[4];
            }
            if (beta == 5.0) {
                return B_3[5];
            }
            if (beta == 8.0) {
                return B_3[6];
            }
        }
        if (lambda == 5.0) {
            if (beta == 0.1) {
                return B_5[0];
            }
            if (beta == 0.5) {
                return B_5[1];
            }
            if (beta == 1.0) {
                return B_5[2];
            }
            if (beta == 2.0) {
                return B_5[3];
            }
            if (beta == 3.0) {
                return B_5[4];
            }
            if (beta == 5.0) {
                return B_5[5];
            }
            if (beta == 8.0) {
                return B_5[6];
            }
        }
        if (lambda == 8.0) {
            if (beta == 0.1) {
                return B_8[0];
            }
            if (beta == 0.5) {
                return B_8[1];
            }
            if (beta == 1.0) {
                return B_8[2];
            }
            if (beta == 2.0) {
                return B_8[3];
            }
            if (beta == 3.0) {
                return B_8[4];
            }
            if (beta == 5.0) {
                return B_8[5];
            }
            if (beta == 8.0) {
                return B_8[6];
            }
        }
        if (beta - 5.0 * lambda - 8.0 >= 0.0) {
            double my = 4.0 * lambda * lambda;
            double c = -0.9189385 + 0.5 * Math.log(beta) + beta;
            double sum = 1.0;
            double prod = 0.0;
            double diff = 8.0;
            double value = 1.0;
            for (int i = 1; (double)Fun.factorial(i) * Math.pow(8.0 * beta, i) <= 1.0E250 && i <= 10; ++i) {
                if (i == 1) {
                    prod = my - 1.0;
                } else {
                    prod *= my - (value += diff);
                    diff *= 2.0;
                }
                sum += prod / ((double)Fun.factorial(i) * Math.pow(8.0 * beta, i));
            }
            double erg = c - Math.log(sum);
            return erg;
        }
        double pi = Math.PI;
        if (lambda > 0.0 && beta - 0.04 * lambda <= 0.0) {
            if (lambda < 11.5) {
                double erg = -Math.log(Fun.gamma(lambda)) - lambda * Math.log(2.0) + lambda * Math.log(beta);
                return erg;
            }
            double erg = -(lambda + 1.0) * Math.log(2.0) - (lambda - 0.5) * Math.log(lambda) + lambda + lambda * Math.log(beta) - 0.5 * Math.log(0.5 * pi);
            return erg;
        }
        double x = 0.0;
        if (beta < 1.57) {
            double newValue2;
            double sum;
            double step;
            double fx = Fun.fkt2Value(lambda, beta, x) * 0.01;
            double y = 0.0;
            while (!(Fun.fkt2Value(lambda, beta, y += 0.1) < fx)) {
            }
            double x1 = step = y * 0.001;
            double firstValue = sum = 0.5 * (10.0 * step + Fun.fkt2Value(lambda, beta, x1)) * step;
            double epsilon = 0.01;
            do {
                x = x1;
                newValue2 = 0.5 * (Fun.fkt2Value(lambda, beta, x) + Fun.fkt2Value(lambda, beta, x1 += step)) * step;
                sum += newValue2;
            } while (!(newValue2 / firstValue < epsilon));
            double erg = -Math.log(2.0 * sum);
            return erg;
        }
        double z1 = beta / 1.57;
        double sum = 0.0;
        double period = pi / z1;
        double step = 0.1 * period;
        double border = 100.0 / ((lambda + 0.1) * (lambda + 0.1));
        int nrPer = (int)Math.ceil(border / period) + 20;
        double x1 = step;
        double z2 = 1.57;
        for (int i = 1; i <= nrPer; ++i) {
            for (j = 1; j <= 10; ++j) {
                newValue = 0.5 * (Fun.fktValue(lambda, z1, z2, x) + Fun.fktValue(lambda, z1, z2, x1)) * step;
                sum += newValue;
                x = x1;
                x1 += step;
            }
        }
        for (j = 1; j <= 5; ++j) {
            newValue = 0.5 * (Fun.fktValue(lambda, z1, z2, x) + Fun.fktValue(lambda, z1, z2, x1)) * step;
            sum += newValue;
            x = x1;
            x1 += step;
        }
        double firstSum = sum;
        for (j = 1; j <= 10; ++j) {
            newValue = 0.5 * (Fun.fktValue(lambda, z1, z2, x) + Fun.fktValue(lambda, z1, z2, x1)) * step;
            sum += newValue;
            x = x1;
            x1 += step;
        }
        double secondSum = sum;
        sum = 0.5 * (firstSum + secondSum);
        double erg = Fun.gamma(lambda + 0.5) * Math.pow(2.0 * z2, lambda) / (Math.sqrt(pi) * Math.pow(z1, lambda)) * sum;
        erg = -Math.log(2.0 * erg);
        return erg;
    }

    public static double bessi0(double x) {
        double ans;
        double d;
        double ax = Math.abs(x);
        if (d < 3.75) {
            double y = x / 3.75;
            y *= y;
            ans = 1.0 + y * (3.5156229 + y * (3.0899424 + y * (1.2067492 + y * (0.2659732 + y * (0.0360768 + y * 0.0045813)))));
        } else {
            double y = 3.75 / ax;
            ans = Math.exp(ax) / Math.sqrt(ax) * (0.39894228 + y * (0.01328592 + y * (0.00225319 + y * (-0.00157565 + y * (0.00916281 + y * (-0.02057706 + y * (0.02635537 + y * (-0.01647633 + y * 0.00392377))))))));
        }
        return ans;
    }

    public static double bessi1(double x) {
        double ans;
        double d;
        double ax = Math.abs(x);
        if (d < 3.75) {
            double y = x / 3.75;
            y *= y;
            ans = ax * (0.5 + y * (0.87890594 + y * (0.51498869 + y * (0.15084934 + y * (0.02658733 + y * (0.00301532 + y * 3.2411E-4))))));
        } else {
            double y = 3.75 / ax;
            ans = 0.02282967 + y * (-0.02895312 + y * (0.01787654 - y * 0.00420059));
            ans = 0.39894228 + y * (-0.03988024 + y * (-0.00362018 + y * (0.00163801 + y * (-0.01031555 + y * ans))));
            ans *= Math.exp(ax) / Math.sqrt(ax);
        }
        return x < 0.0 ? -ans : ans;
    }

    public static long factorial(int n) {
        return Arithmetic.longFactorial(n);
    }

    private static double fkt2Value(double lambda, double beta, double xValue) {
        return Fun.cosh(lambda * xValue) * Math.exp(-beta * Fun.cosh(xValue));
    }

    private static double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double gamma(double x) {
        x = Fun.logGamma(x);
        return Math.exp(x);
    }

    public static double logGamma(double x) {
        if (x <= 0.0) {
            return -999.0;
        }
        double z = 1.0;
        while (x < 11.0) {
            z *= x;
            x += 1.0;
        }
        double r = 1.0 / (x * x);
        double c6 = -0.0019175269175269174;
        double c5 = 8.417508417508417E-4;
        double c4 = -5.952380952380953E-4;
        double c3 = 7.936507936507937E-4;
        double c2 = -0.002777777777777778;
        double c1 = 0.08333333333333333;
        double g = c1 + r * (c2 + r * (c3 + r * (c4 + r * (c5 + r + c6))));
        double c0 = 0.9189385332046728;
        g = (x - 0.5) * Math.log(x) - x + c0 + g / x;
        if (z == 1.0) {
            return g;
        }
        return g - Math.log(z);
    }
}

