/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.math.Arithmetic;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;

@Deprecated
public class HyperGeometric
extends AbstractDiscreteDistribution {
    private int myN;
    private int mys;
    private int myn;
    private int lastN = -1;
    private int lastM = -1;
    private int lastn = -1;
    private int NMn;
    private int m;
    private int mp;
    private int b;
    private double Mp;
    private double np;
    private double fm;
    private int k2;
    private int k4;
    private int k1;
    private int k5;
    private double dl;
    private double dr;
    private double r1;
    private double r2;
    private double r4;
    private double r5;
    private double ll;
    private double lr;
    private double cpm;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double p5;
    private double p6;

    public HyperGeometric(int N, int s, int n, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(N, s, n);
    }

    private static double fcLnpk(int k, int N_Mn, int M, int n) {
        return Arithmetic.logFactorial(k) + Arithmetic.logFactorial(M - k) + Arithmetic.logFactorial(n - k) + Arithmetic.logFactorial(N_Mn + k);
    }

    protected int hmdu(int N, int M, int n, Random randomGenerator) {
        if (N != this.lastN || M != this.lastM || n != this.lastn) {
            this.lastN = N;
            this.lastM = M;
            this.lastn = n;
            this.Mp = M + 1;
            this.np = n + 1;
            this.NMn = N - M - n;
            double p = this.Mp / ((double)N + 2.0);
            double nu = this.np * p;
            this.m = (int)nu;
            this.mp = (double)this.m == nu && p == 0.5 ? this.m-- : this.m + 1;
            this.fm = Math.exp(Arithmetic.logFactorial(N - M) - Arithmetic.logFactorial(this.NMn + this.m) - Arithmetic.logFactorial(n - this.m) + Arithmetic.logFactorial(M) - Arithmetic.logFactorial(M - this.m) - Arithmetic.logFactorial(this.m) - Arithmetic.logFactorial(N) + Arithmetic.logFactorial(N - n) + Arithmetic.logFactorial(n));
            this.b = (int)(nu + 11.0 * Math.sqrt(nu * (1.0 - p) * (1.0 - (double)n / (double)N) + 1.0));
            if (this.b > n) {
                this.b = n;
            }
        }
        block0: while (true) {
            int K;
            double d;
            double d2;
            double U = randomGenerator.nextDouble() - this.fm;
            if (d2 <= 0.0) {
                return this.m;
            }
            double c = d = this.fm;
            for (int I = 1; I <= this.m; ++I) {
                double d3;
                double d4;
                K = this.mp - I;
                U -= (c *= (double)K / (this.np - (double)K) * ((double)(this.NMn + K) / (this.Mp - (double)K)));
                if (d4 <= 0.0) {
                    return K - 1;
                }
                K = this.m + I;
                U -= (d *= (this.np - (double)K) / (double)K * ((this.Mp - (double)K) / (double)(this.NMn + K)));
                if (!(d3 <= 0.0)) continue;
                return K;
            }
            K = this.mp + this.m;
            while (true) {
                double d5;
                if (K > this.b) continue block0;
                U -= (d *= (this.np - (double)K) / (double)K * ((this.Mp - (double)K) / (double)(this.NMn + K)));
                if (d5 <= 0.0) {
                    return K;
                }
                ++K;
            }
            break;
        }
    }

    protected int hprs(int N, int M, int n, Random randomGenerator) {
        int X;
        double U;
        if (N != this.lastN || M != this.lastM || n != this.lastn) {
            this.lastN = N;
            this.lastM = M;
            this.lastn = n;
            double Mp = M + 1;
            double np = n + 1;
            this.NMn = N - M - n;
            double p = Mp / ((double)N + 2.0);
            double nu = np * p;
            U = Math.sqrt(nu * (1.0 - p) * (1.0 - ((double)n + 2.0) / ((double)N + 3.0)) + 0.25);
            this.m = (int)nu;
            this.k2 = (int)Math.ceil(nu - 0.5 - U);
            if (this.k2 >= this.m) {
                this.k2 = this.m - 1;
            }
            this.k4 = (int)(nu - 0.5 + U);
            this.k1 = this.k2 + this.k2 - this.m + 1;
            this.k5 = this.k4 + this.k4 - this.m;
            this.dl = this.k2 - this.k1;
            this.dr = this.k5 - this.k4;
            this.r1 = (np / (double)this.k1 - 1.0) * (Mp - (double)this.k1) / (double)(this.NMn + this.k1);
            this.r2 = (np / (double)this.k2 - 1.0) * (Mp - (double)this.k2) / (double)(this.NMn + this.k2);
            this.r4 = (np / (double)(this.k4 + 1) - 1.0) * (double)(M - this.k4) / (double)(this.NMn + this.k4 + 1);
            this.r5 = (np / (double)(this.k5 + 1) - 1.0) * (double)(M - this.k5) / (double)(this.NMn + this.k5 + 1);
            this.ll = Math.log(this.r1);
            this.lr = -Math.log(this.r5);
            this.cpm = HyperGeometric.fcLnpk(this.m, this.NMn, M, n);
            this.f2 = Math.exp(this.cpm - HyperGeometric.fcLnpk(this.k2, this.NMn, M, n));
            this.f4 = Math.exp(this.cpm - HyperGeometric.fcLnpk(this.k4, this.NMn, M, n));
            this.f1 = Math.exp(this.cpm - HyperGeometric.fcLnpk(this.k1, this.NMn, M, n));
            this.f5 = Math.exp(this.cpm - HyperGeometric.fcLnpk(this.k5, this.NMn, M, n));
            this.p1 = this.f2 * (this.dl + 1.0);
            this.p2 = this.f2 * this.dl + this.p1;
            this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
            this.p4 = this.f4 * this.dr + this.p3;
            this.p5 = this.f1 / this.ll + this.p4;
            this.p6 = this.f5 / this.lr + this.p5;
        }
        while (true) {
            int Dk;
            double Y;
            double W;
            double d;
            U = randomGenerator.nextDouble() * this.p6;
            if (d < this.p2) {
                double d2;
                double d3;
                double d4;
                W = U - this.p1;
                if (d4 < 0.0) {
                    return this.k2 + (int)(U / this.f2);
                }
                Y = W / this.dl;
                if (d3 < this.f1) {
                    return this.k1 + (int)(W / this.f1);
                }
                Dk = randomGenerator.nextInt((int)this.dl) + 1;
                if (Y <= this.f2 - (double)Dk * (this.f2 - this.f2 / this.r2)) {
                    return this.k2 - Dk;
                }
                W = this.f2 + this.f2 - Y;
                if (d2 < 1.0) {
                    int V = this.k2 + Dk;
                    if (W <= this.f2 + (double)Dk * (1.0 - this.f2) / (this.dl + 1.0)) {
                        return V;
                    }
                    if (Math.log(W) <= this.cpm - HyperGeometric.fcLnpk(V, this.NMn, M, n)) {
                        return V;
                    }
                }
                X = this.k2 - Dk;
            } else if (U < this.p4) {
                double d5;
                double d6;
                double d7;
                W = U - this.p3;
                if (d7 < 0.0) {
                    return this.k4 - (int)((U - this.p2) / this.f4);
                }
                Y = W / this.dr;
                if (d6 < this.f5) {
                    return this.k5 - (int)(W / this.f5);
                }
                Dk = randomGenerator.nextInt((int)this.dr) + 1;
                if (Y <= this.f4 - (double)Dk * (this.f4 - this.f4 * this.r4)) {
                    return this.k4 + Dk;
                }
                W = this.f4 + this.f4 - Y;
                if (d5 < 1.0) {
                    int V = this.k4 - Dk;
                    if (W <= this.f4 + (double)Dk * (1.0 - this.f4) / this.dr) {
                        return V;
                    }
                    if (Math.log(W) <= this.cpm - HyperGeometric.fcLnpk(V, this.NMn, M, n)) {
                        return V;
                    }
                }
                X = this.k4 + Dk;
            } else {
                Y = randomGenerator.nextDouble();
                if (U < this.p5) {
                    Dk = (int)(1.0 - Math.log(Y) / this.ll);
                    X = this.k1 - Dk;
                    if (X < 0) continue;
                    if ((Y *= (U - this.p4) * this.ll) <= this.f1 - (double)Dk * (this.f1 - this.f1 / this.r1)) {
                        return X;
                    }
                } else {
                    Dk = (int)(1.0 - Math.log(Y) / this.lr);
                    X = this.k5 + Dk;
                    if (X > n) continue;
                    if ((Y *= (U - this.p5) * this.lr) <= this.f5 - (double)Dk * (this.f5 - this.f5 * this.r5)) {
                        return X;
                    }
                }
            }
            if (Math.log(Y) <= this.cpm - HyperGeometric.fcLnpk(X, this.NMn, M, n)) break;
        }
        return X;
    }

    public int nextInt() {
        return this.nextInt(this.myN, this.mys, this.myn, this.randomGenerator);
    }

    public int nextInt(int N, int s, int n) {
        return this.nextInt(N, s, n, this.randomGenerator);
    }

    protected int nextInt(int N, int M, int n, Random randomGenerator) {
        int K;
        int mLeNhalf;
        int Nhalf = N / 2;
        int nLeNhalf = n <= Nhalf ? n : N - n;
        int n2 = mLeNhalf = M <= Nhalf ? M : N - M;
        if (n * M / N < 10) {
            K = nLeNhalf <= mLeNhalf ? this.hmdu(N, mLeNhalf, nLeNhalf, randomGenerator) : this.hmdu(N, nLeNhalf, mLeNhalf, randomGenerator);
        } else {
            int n3 = K = nLeNhalf <= mLeNhalf ? this.hprs(N, mLeNhalf, nLeNhalf, randomGenerator) : this.hprs(N, nLeNhalf, mLeNhalf, randomGenerator);
        }
        if (n <= Nhalf) {
            return M <= Nhalf ? K : n - K;
        }
        return M <= Nhalf ? M - K : n - N + M + K;
    }

    public double pdf(int k) {
        return Arithmetic.binomial(this.mys, (long)k) * Arithmetic.binomial(this.myN - this.mys, (long)(this.myn - k)) / Arithmetic.binomial(this.myN, (long)this.myn);
    }

    public void setState(int N, int s, int n) {
        this.myN = N;
        this.mys = s;
        this.myn = n;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.myN + ',' + this.mys + ',' + this.myn + ')';
    }
}

