/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;

@Deprecated
public class Hyperbolic
extends AbstractContinousDistribution {
    private static final Hyperbolic SHARED = new Hyperbolic(10.0, 10.0, RandomUtils.getRandom());
    private double alpha;
    private double beta;
    private double aSetup;
    private double bSetup = -1.0;
    private double hr;
    private double hl;
    private double s;
    private double pm;
    private double pr;
    private double samb;
    private double pmr;
    private double mpa1;
    private double mmb1;

    public Hyperbolic(double alpha, double beta, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(alpha, beta);
    }

    public double nextDouble() {
        return this.nextDouble(this.alpha, this.beta);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double nextDouble(double alpha, double beta) {
        if (this.aSetup != alpha || this.bSetup != beta) {
            double amb = alpha * alpha - beta * beta;
            this.samb = Math.sqrt(amb);
            double mode = beta / this.samb;
            double help1 = alpha * Math.sqrt(2.0 * this.samb + 1.0);
            double help2 = beta * (this.samb + 1.0);
            double mpa = (help2 + help1) / amb;
            double mmb = (help2 - help1) / amb;
            double a = mpa - mode;
            double b = -mmb + mode;
            this.hr = -1.0 / (-alpha * mpa / Math.sqrt(1.0 + mpa * mpa) + beta);
            this.hl = 1.0 / (-alpha * mmb / Math.sqrt(1.0 + mmb * mmb) + beta);
            double a1 = a - this.hr;
            double b1 = b - this.hl;
            this.mmb1 = mode - b1;
            this.mpa1 = mode + a1;
            this.s = a + b;
            this.pm = (a1 + b1) / this.s;
            this.pr = this.hr / this.s;
            this.pmr = this.pm + this.pr;
            this.aSetup = alpha;
            this.bSetup = beta;
        }
        while (true) {
            double e;
            double x;
            double u = this.randomGenerator.nextDouble();
            double v = this.randomGenerator.nextDouble();
            if (u <= this.pm) {
                x = this.mmb1 + u * this.s;
                if (!(Math.log(v) <= -alpha * Math.sqrt(1.0 + x * x) + beta * x + this.samb)) continue;
                return x;
            }
            if (u <= this.pmr) {
                e = -Math.log((u - this.pm) / this.pr);
                x = this.mpa1 + this.hr * e;
                if (!(Math.log(v) - e <= -alpha * Math.sqrt(1.0 + x * x) + beta * x + this.samb)) continue;
                return x;
            }
            e = Math.log((u - this.pmr) / (1.0 - this.pmr));
            x = this.mmb1 + this.hl * e;
            if (Math.log(v) + e <= -alpha * Math.sqrt(1.0 + x * x) + beta * x + this.samb) return x;
        }
    }

    public void setState(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double staticNextDouble(double alpha, double beta) {
        Hyperbolic hyperbolic = SHARED;
        synchronized (hyperbolic) {
            return SHARED.nextDouble(alpha, beta);
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.alpha + ',' + this.beta + ')';
    }
}

