/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Locale;
import java.util.Random;
import org.apache.mahout.math.jet.random.AbstractContinousDistribution;
import org.apache.mahout.math.jet.stat.Probability;

public class Normal
extends AbstractContinousDistribution {
    private double mean;
    private double variance;
    private double standardDeviation;
    private double cache;
    private boolean cacheFilled;
    private double normalizer;

    public Normal(double mean, double standardDeviation, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(mean, standardDeviation);
    }

    public double cdf(double x) {
        return Probability.normal(this.mean, this.variance, x);
    }

    public double pdf(double x) {
        double diff = x - this.mean;
        return this.normalizer * Math.exp(-(diff * diff) / (2.0 * this.variance));
    }

    public double nextDouble() {
        double y;
        double x;
        double r;
        if (this.cacheFilled) {
            this.cacheFilled = false;
            return this.cache;
        }
        while ((r = (x = 2.0 * this.randomGenerator.nextDouble() - 1.0) * x + (y = 2.0 * this.randomGenerator.nextDouble() - 1.0) * y) >= 1.0) {
        }
        double z = Math.sqrt(-2.0 * Math.log(r) / r);
        this.cache = this.mean + this.standardDeviation * x * z;
        this.cacheFilled = true;
        return this.mean + this.standardDeviation * y * z;
    }

    public final void setRandomGenerator(Random randomGenerator) {
        super.setRandomGenerator(randomGenerator);
        this.cacheFilled = false;
    }

    public final void setState(double mean, double standardDeviation) {
        if (mean != this.mean || standardDeviation != this.standardDeviation) {
            this.mean = mean;
            this.standardDeviation = standardDeviation;
            this.variance = standardDeviation * standardDeviation;
            this.cacheFilled = false;
            this.normalizer = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        }
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s(m=%f, sd=%f)", this.getClass().getName(), this.mean, this.standardDeviation);
    }
}

