/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.math.Arithmetic;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;
import org.apache.mahout.math.jet.stat.Probability;

public class Poisson
extends AbstractDiscreteDistribution {
    private double mean;
    private double myOld = -1.0;
    private double p;
    private double q;
    private double p0;
    private double[] pp = new double[36];
    private int llll;
    private double myLast = -1.0;
    private double ll;
    private int k2;
    private int k4;
    private int k1;
    private int k5;
    private double dl;
    private double dr;
    private double r1;
    private double r2;
    private double r4;
    private double r5;
    private double lr;
    private double lMy;
    private double cPm;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double p5;
    private double p6;
    private static final double MEAN_MAX = 2.147483647E9;
    private static final double SWITCH_MEAN = 10.0;

    public Poisson(double mean, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.mean = mean;
    }

    @Deprecated
    public double cdf(int k) {
        return Probability.poisson(k, this.mean);
    }

    @Deprecated
    public Object clone() {
        Poisson copy = (Poisson)super.clone();
        if (this.pp != null) {
            copy.pp = (double[])this.pp.clone();
        }
        return copy;
    }

    private static double f(int k, double lNu, double cPm) {
        return Math.exp((double)k * lNu - Arithmetic.logFactorial(k) - cPm);
    }

    public int nextInt() {
        return this.nextInt(this.mean);
    }

    public int nextInt(double theMean) {
        Random gen = this.randomGenerator;
        if (theMean < 10.0) {
            if (theMean != this.myOld) {
                this.myOld = theMean;
                this.llll = 0;
                this.q = this.p = Math.exp(-theMean);
                this.p0 = this.p;
            }
            int m = theMean > 1.0 ? (int)theMean : 1;
            while (true) {
                double u = gen.nextDouble();
                int k = 0;
                if (u <= this.p0) {
                    return k;
                }
                if (this.llll != 0) {
                    int i;
                    for (k = i = u > 0.458 ? Math.min(this.llll, m) : 1; k <= this.llll; ++k) {
                        if (!(u <= this.pp[k])) continue;
                        return k;
                    }
                    if (this.llll == 35) continue;
                }
                for (k = this.llll + 1; k <= 35; ++k) {
                    this.p *= theMean / (double)k;
                    this.q += this.p;
                    this.pp[k] = this.q;
                    if (!(u <= this.q)) continue;
                    this.llll = k;
                    return k;
                }
                this.llll = 35;
            }
        }
        if (theMean < 2.147483647E9) {
            int X;
            int m = (int)theMean;
            if (theMean != this.myLast) {
                this.myLast = theMean;
                double Ds = Math.sqrt(theMean + 0.25);
                this.k2 = (int)Math.ceil(theMean - 0.5 - Ds);
                this.k4 = (int)(theMean - 0.5 + Ds);
                this.k1 = this.k2 + this.k2 - m + 1;
                this.k5 = this.k4 + this.k4 - m;
                this.dl = this.k2 - this.k1;
                this.dr = this.k5 - this.k4;
                this.r1 = theMean / (double)this.k1;
                this.r2 = theMean / (double)this.k2;
                this.r4 = theMean / (double)(this.k4 + 1);
                this.r5 = theMean / (double)(this.k5 + 1);
                this.ll = Math.log(this.r1);
                this.lr = -Math.log(this.r5);
                this.lMy = Math.log(theMean);
                this.cPm = (double)m * this.lMy - Arithmetic.logFactorial(m);
                this.f2 = Poisson.f(this.k2, this.lMy, this.cPm);
                this.f4 = Poisson.f(this.k4, this.lMy, this.cPm);
                this.f1 = Poisson.f(this.k1, this.lMy, this.cPm);
                this.f5 = Poisson.f(this.k5, this.lMy, this.cPm);
                this.p1 = this.f2 * (this.dl + 1.0);
                this.p2 = this.f2 * this.dl + this.p1;
                this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
                this.p4 = this.f4 * this.dr + this.p3;
                this.p5 = this.f1 / this.ll + this.p4;
                this.p6 = this.f5 / this.lr + this.p5;
            }
            while (true) {
                int Y;
                int Dk;
                double W;
                double V;
                double d;
                double U = gen.nextDouble() * this.p6;
                if (d < this.p2) {
                    double d2;
                    double d3;
                    double d4;
                    V = U - this.p1;
                    if (d4 < 0.0) {
                        return this.k2 + (int)(U / this.f2);
                    }
                    W = V / this.dl;
                    if (d3 < this.f1) {
                        return this.k1 + (int)(V / this.f1);
                    }
                    Dk = gen.nextInt((int)this.dl) + 1;
                    if (W <= this.f2 - (double)Dk * (this.f2 - this.f2 / this.r2)) {
                        return this.k2 - Dk;
                    }
                    V = this.f2 + this.f2 - W;
                    if (d2 < 1.0) {
                        Y = this.k2 + Dk;
                        if (V <= this.f2 + (double)Dk * (1.0 - this.f2) / (this.dl + 1.0)) {
                            return Y;
                        }
                        if (V <= Poisson.f(Y, this.lMy, this.cPm)) {
                            return Y;
                        }
                    }
                    X = this.k2 - Dk;
                } else if (U < this.p4) {
                    double d5;
                    double d6;
                    double d7;
                    V = U - this.p3;
                    if (d7 < 0.0) {
                        return this.k4 - (int)((U - this.p2) / this.f4);
                    }
                    W = V / this.dr;
                    if (d6 < this.f5) {
                        return this.k5 - (int)(V / this.f5);
                    }
                    Dk = gen.nextInt((int)this.dr) + 1;
                    if (W <= this.f4 - (double)Dk * (this.f4 - this.f4 * this.r4)) {
                        return this.k4 + Dk;
                    }
                    V = this.f4 + this.f4 - W;
                    if (d5 < 1.0) {
                        Y = this.k4 - Dk;
                        if (V <= this.f4 + (double)Dk * (1.0 - this.f4) / this.dr) {
                            return Y;
                        }
                        if (V <= Poisson.f(Y, this.lMy, this.cPm)) {
                            return Y;
                        }
                    }
                    X = this.k4 + Dk;
                } else {
                    W = gen.nextDouble();
                    if (U < this.p5) {
                        Dk = (int)(1.0 - Math.log(W) / this.ll);
                        X = this.k1 - Dk;
                        if (X < 0) continue;
                        if ((W *= (U - this.p4) * this.ll) <= this.f1 - (double)Dk * (this.f1 - this.f1 / this.r1)) {
                            return X;
                        }
                    } else {
                        Dk = (int)(1.0 - Math.log(W) / this.lr);
                        X = this.k5 + Dk;
                        if ((W *= (U - this.p5) * this.lr) <= this.f5 - (double)Dk * (this.f5 - this.f5 * this.r5)) {
                            return X;
                        }
                    }
                }
                if (Math.log(W) <= (double)X * this.lMy - Arithmetic.logFactorial(X) - this.cPm) break;
            }
            return X;
        }
        return (int)theMean;
    }

    @Deprecated
    public double pdf(int k) {
        return Math.exp((double)k * Math.log(this.mean) - Arithmetic.logFactorial(k) - this.mean);
    }

    @Deprecated
    public void setMean(double mean) {
        this.mean = mean;
    }

    @Deprecated
    public String toString() {
        return this.getClass().getName() + '(' + this.mean + ')';
    }
}

