/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;

@Deprecated
public class PoissonSlow
extends AbstractDiscreteDistribution {
    private static final double MEAN_MAX = 2.147483647E9;
    private static final double SWITCH_MEAN = 12.0;
    private static final double[] COF = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
    private double mean;
    private double cachedSq;
    private double cachedAlxm;
    private double cachedG;

    public PoissonSlow(double mean, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setMean(mean);
    }

    private static double logGamma(double xx) {
        double x = xx - 1.0;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        double[] coeff = COF;
        for (int j = 0; j <= 5; ++j) {
            ser += coeff[j] / (x += 1.0);
        }
        return -tmp + Math.log(2.5066282746310007 * ser);
    }

    public int nextInt() {
        double g = this.cachedG;
        if (this.mean == -1.0) {
            return 0;
        }
        if (this.mean < 12.0) {
            int poisson = -1;
            double product = 1.0;
            do {
                ++poisson;
            } while ((product *= this.randomGenerator.nextDouble()) >= g);
            return poisson;
        }
        if (this.mean < 2.147483647E9) {
            double em;
            double sq = this.cachedSq;
            double alxm = this.cachedAlxm;
            Random rand = this.randomGenerator;
            while (true) {
                double y;
                if ((em = sq * (y = Math.tan(Math.PI * rand.nextDouble())) + this.mean) < 0.0) {
                    continue;
                }
                em = (int)em;
                double t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - PoissonSlow.logGamma(em + 1.0) - g);
                if (!(rand.nextDouble() > t)) break;
            }
            return (int)em;
        }
        return (int)this.mean;
    }

    protected int nextIntSlow() {
        double bound = Math.exp(-this.mean);
        int count = 0;
        double product = 1.0;
        while (product >= bound && product > 0.0) {
            product *= this.randomGenerator.nextDouble();
            ++count;
        }
        if (product <= 0.0 && bound > 0.0) {
            return (int)Math.round(this.mean);
        }
        return count - 1;
    }

    public void setMean(double mean) {
        if (mean != this.mean) {
            this.mean = mean;
            if (mean == -1.0) {
                return;
            }
            if (mean < 12.0) {
                this.cachedG = Math.exp(-mean);
            } else {
                this.cachedSq = Math.sqrt(2.0 * mean);
                this.cachedAlxm = Math.log(mean);
                this.cachedG = mean * this.cachedAlxm - PoissonSlow.logGamma(mean + 1.0);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.mean + ')';
    }
}

