/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random;

import java.util.Random;
import org.apache.mahout.math.jet.random.AbstractDiscreteDistribution;

@Deprecated
public class Zeta
extends AbstractDiscreteDistribution {
    private static final double MAX_LONG_INT = 9.223372036854776E18;
    private double ro;
    private double pk;
    private double c;
    private double d;
    private double roPrev = -1.0;
    private double pkPrev = -1.0;

    public Zeta(double ro, double pk, Random randomGenerator) {
        this.setRandomGenerator(randomGenerator);
        this.setState(ro, pk);
    }

    public int nextInt() {
        return (int)this.generateZeta(this.ro, this.pk, this.randomGenerator);
    }

    protected long generateZeta(double ro, double pk, Random randomGenerator) {
        long k;
        if (ro != this.roPrev || pk != this.pkPrev) {
            this.roPrev = ro;
            this.pkPrev = pk;
            if (ro < pk) {
                this.c = pk - 0.5;
                this.d = 0.0;
            } else {
                this.c = ro - 0.5;
                this.d = (1.0 + ro) * Math.log((1.0 + pk) / (1.0 + ro));
            }
        }
        while (true) {
            double u = randomGenerator.nextDouble();
            double v = randomGenerator.nextDouble();
            double x = (this.c + 0.5) * Math.exp(-Math.log(u) / ro) - this.c;
            if (x <= 0.5 || x >= 9.223372036854776E18) continue;
            k = (int)(x + 0.5);
            double e = -Math.log(v);
            if (!(e < (1.0 + ro) * Math.log(((double)k + pk) / (x + this.c)) - this.d)) break;
        }
        return k;
    }

    public void setState(double ro, double pk) {
        this.ro = ro;
        this.pk = pk;
    }

    public String toString() {
        return this.getClass().getName() + '(' + this.ro + ',' + this.pk + ')';
    }
}

