/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.random.engine;

import java.util.Date;
import org.apache.mahout.math.jet.random.engine.RandomEngine;

public final class MersenneTwister
extends RandomEngine {
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private static final int MAG0 = 0;
    private static final int MAG1 = -1727483681;
    private static final int DEFAULT_SEED = 4357;
    private int mti;
    private int[] mt = new int[624];

    public MersenneTwister() {
        this(4357);
    }

    public MersenneTwister(int seed) {
        this.setSeed(seed);
    }

    public MersenneTwister(Date d) {
        this((int)d.getTime());
    }

    public Object clone() {
        MersenneTwister clone = (MersenneTwister)super.clone();
        clone.mt = (int[])this.mt.clone();
        return clone;
    }

    void nextBlock() {
        int y;
        int kk;
        for (kk = 0; kk < 227; ++kk) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + 397] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        }
        while (kk < 623) {
            y = this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE;
            this.mt[kk] = this.mt[kk + -227] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
            ++kk;
        }
        y = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
        this.mt[623] = this.mt[396] ^ y >>> 1 ^ ((y & 1) == 0 ? 0 : -1727483681);
        this.mti = 0;
    }

    public int nextInt() {
        if (this.mti == 624) {
            this.nextBlock();
        }
        int y = this.mt[this.mti++];
        y ^= y >>> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >>> 18;
        return y;
    }

    void setSeed(int seed) {
        this.mt[0] = seed;
        for (int i = 1; i < 624; ++i) {
            this.mt[i] = 1812433253 * (this.mt[i - 1] ^ this.mt[i - 1] >> 30) + i;
        }
        this.mti = 624;
    }

    void setReferenceSeed(int seed) {
        int i = 0;
        while (i < 624) {
            this.mt[i] = seed & 0xFFFF0000;
            seed = 69069 * seed + 1;
            int n = i++;
            this.mt[n] = this.mt[n] | (seed & 0xFFFF0000) >>> 16;
            seed = 69069 * seed + 1;
        }
        this.mti = 624;
    }
}

