/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.jet.stat;

import org.apache.mahout.math.jet.math.Constants;
import org.apache.mahout.math.jet.math.Polynomial;

public class Gamma
extends Constants {
    protected Gamma() {
    }

    public static double beta(double alpha, double beta) {
        double y;
        if (alpha < 40.0 && beta < 40.0) {
            y = Gamma.gamma(alpha + beta);
            if (y == 0.0) {
                return 1.0;
            }
            if (alpha > beta) {
                y = Gamma.gamma(alpha) / y;
                y *= Gamma.gamma(beta);
            } else {
                y = Gamma.gamma(beta) / y;
                y *= Gamma.gamma(alpha);
            }
        } else {
            y = Math.exp(Gamma.logGamma(alpha) + Gamma.logGamma(beta) - Gamma.logGamma(alpha + beta));
        }
        return y;
    }

    public static double gamma(double x) {
        double[] pCoefficient = new double[]{1.6011952247675185E-4, 0.0011913514700658638, 0.010421379756176158, 0.04763678004571372, 0.20744822764843598, 0.4942148268014971, 1.0};
        double[] qCoefficient = new double[]{-2.3158187332412014E-5, 5.396055804933034E-4, -0.004456419138517973, 0.011813978522206043, 0.035823639860549865, -0.23459179571824335, 0.0714304917030273, 1.0};
        double q = Math.abs(x);
        if (q > 33.0) {
            if (x < 0.0) {
                double p = Math.floor(q);
                if (p == q) {
                    throw new ArithmeticException("gamma: overflow");
                }
                double z = q - p;
                if (z > 0.5) {
                    z = q - (p += 1.0);
                }
                if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                    throw new ArithmeticException("gamma: overflow");
                }
                z = Math.abs(z);
                z = Math.PI / (z * Gamma.stirlingFormula(q));
                return -z;
            }
            return Gamma.stirlingFormula(x);
        }
        double z = 1.0;
        while (x >= 3.0) {
            z *= (x -= 1.0);
        }
        while (x < 0.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x > -1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        while (x < 2.0) {
            if (x == 0.0) {
                throw new ArithmeticException("gamma: singular");
            }
            if (x < 1.0E-9) {
                return z / ((1.0 + 0.5772156649015329 * x) * x);
            }
            z /= x;
            x += 1.0;
        }
        if (x == 2.0 || x == 3.0) {
            return z;
        }
        double p = Polynomial.polevl(x -= 2.0, pCoefficient, 6);
        q = Polynomial.polevl(x, qCoefficient, 7);
        return z * p / q;
    }

    public static double incompleteBeta(double alpha, double beta, double xx) {
        double x;
        double xc;
        double b;
        double a;
        if (alpha <= 0.0) {
            throw new ArithmeticException("incompleteBeta: Domain error! alpha must be > 0, but was " + alpha);
        }
        if (beta <= 0.0) {
            throw new ArithmeticException("incompleteBeta: Domain error! beta must be > 0, but was " + beta);
        }
        if (xx <= 0.0) {
            return 0.0;
        }
        if (xx >= 1.0) {
            return 1.0;
        }
        if (beta * xx <= 1.0 && xx <= 0.95) {
            double t = Gamma.powerSeries(alpha, beta, xx);
            return t;
        }
        double w = 1.0 - xx;
        boolean flag = false;
        if (xx > alpha / (alpha + beta)) {
            flag = true;
            a = beta;
            b = alpha;
            xc = xx;
            x = w;
        } else {
            a = alpha;
            b = beta;
            xc = w;
            x = xx;
        }
        if (flag && b * x <= 1.0 && x <= 0.95) {
            double t = Gamma.powerSeries(a, b, x);
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            return t;
        }
        double y = x * (a + b - 2.0) - (a - 1.0);
        w = y < 0.0 ? Gamma.incompleteBetaFraction1(a, b, x) : Gamma.incompleteBetaFraction2(a, b, x) / xc;
        y = a * Math.log(x);
        double t = b * Math.log(xc);
        if (a + b < 171.6243769563027 && Math.abs(y) < 709.782712893384 && Math.abs(t) < 709.782712893384) {
            t = Math.pow(xc, b);
            t *= Math.pow(x, a);
            t /= a;
            t *= w;
            t *= Gamma.gamma(a + b) / (Gamma.gamma(a) * Gamma.gamma(b));
            if (flag) {
                t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
            }
            return t;
        }
        y += t + Gamma.logGamma(a + b) - Gamma.logGamma(a) - Gamma.logGamma(b);
        double d = t = (y += Math.log(w / a)) < -745.1332191019412 ? 0.0 : Math.exp(y);
        if (flag) {
            t = t <= (double)1.110223E-16f ? 0.9999999999999999 : 1.0 - t;
        }
        return t;
    }

    static double incompleteBetaFraction1(double a, double b, double x) {
        double k1 = a;
        double k2 = a + b;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = b - 1.0;
        double k7 = k4;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(x * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = x * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 += 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 -= 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    static double incompleteBetaFraction2(double a, double b, double x) {
        double k1 = a;
        double k2 = b - 1.0;
        double k3 = a;
        double k4 = a + 1.0;
        double k5 = 1.0;
        double k6 = a + b;
        double k7 = a + 1.0;
        double k8 = a + 2.0;
        double pkm2 = 0.0;
        double qkm2 = 1.0;
        double pkm1 = 1.0;
        double qkm1 = 1.0;
        double z = x / (1.0 - x);
        double ans = 1.0;
        double r = 1.0;
        int n = 0;
        double thresh = 3.330669E-16f;
        do {
            double t;
            double xk = -(z * k1 * k2) / (k3 * k4);
            double pk = pkm1 + pkm2 * xk;
            double qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            xk = z * k5 * k6 / (k7 * k8);
            pk = pkm1 + pkm2 * xk;
            qk = qkm1 + qkm2 * xk;
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (qk != 0.0) {
                r = pk / qk;
            }
            if (r != 0.0) {
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            if (t < thresh) {
                return ans;
            }
            k1 += 1.0;
            k2 -= 1.0;
            k3 += 2.0;
            k4 += 2.0;
            k5 += 1.0;
            k6 += 1.0;
            k7 += 2.0;
            k8 += 2.0;
            if (Math.abs(qk) + Math.abs(pk) > 4.503599627370496E15) {
                pkm2 *= 2.220446049250313E-16;
                pkm1 *= 2.220446049250313E-16;
                qkm2 *= 2.220446049250313E-16;
                qkm1 *= 2.220446049250313E-16;
            }
            if (!(Math.abs(qk) < 2.220446049250313E-16) && !(Math.abs(pk) < 2.220446049250313E-16)) continue;
            pkm2 *= 4.503599627370496E15;
            pkm1 *= 4.503599627370496E15;
            qkm2 *= 4.503599627370496E15;
            qkm1 *= 4.503599627370496E15;
        } while (++n < 300);
        return ans;
    }

    public static double incompleteGamma(double alpha, double x) {
        if (x <= 0.0 || alpha <= 0.0) {
            return 0.0;
        }
        if (x > 1.0 && x > alpha) {
            return 1.0 - Gamma.incompleteGammaComplement(alpha, x);
        }
        double ax = alpha * Math.log(x) - x - Gamma.logGamma(alpha);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double r = alpha;
        double c = 1.0;
        double ans = 1.0;
        while ((c *= x / (r += 1.0)) / (ans += c) > (double)1.110223E-16f) {
        }
        return ans * ax / alpha;
    }

    public static double incompleteGammaComplement(double alpha, double x) {
        double t;
        if (x <= 0.0 || alpha <= 0.0) {
            return 1.0;
        }
        if (x < 1.0 || x < alpha) {
            return 1.0 - Gamma.incompleteGamma(alpha, x);
        }
        double ax = alpha * Math.log(x) - x - Gamma.logGamma(alpha);
        if (ax < -709.782712893384) {
            return 0.0;
        }
        ax = Math.exp(ax);
        double y = 1.0 - alpha;
        double z = x + y + 1.0;
        double c = 0.0;
        double pkm2 = 1.0;
        double qkm2 = x;
        double pkm1 = x + 1.0;
        double qkm1 = z * x;
        double ans = pkm1 / qkm1;
        do {
            double yc = (y += 1.0) * (c += 1.0);
            double pk = pkm1 * (z += 2.0) - pkm2 * yc;
            double qk = qkm1 * z - qkm2 * yc;
            if (qk != 0.0) {
                double r = pk / qk;
                t = Math.abs((ans - r) / r);
                ans = r;
            } else {
                t = 1.0;
            }
            pkm2 = pkm1;
            pkm1 = pk;
            qkm2 = qkm1;
            qkm1 = qk;
            if (!(Math.abs(pk) > 4.503599627370496E15)) continue;
            pkm2 *= 2.220446049250313E-16;
            pkm1 *= 2.220446049250313E-16;
            qkm2 *= 2.220446049250313E-16;
            qkm1 *= 2.220446049250313E-16;
        } while (t > (double)1.110223E-16f);
        return ans * ax;
    }

    public static double logGamma(double x) {
        double[] aCoefficient = new double[]{8.116141674705085E-4, -5.950619042843014E-4, 7.936503404577169E-4, -0.002777777777300997, 0.08333333333333319};
        double[] bCoefficient = new double[]{-1378.2515256912086, -38801.631513463784, -331612.9927388712, -1162370.974927623, -1721737.0082083966, -853555.6642457654};
        double[] cCoefficient = new double[]{-351.81570143652345, -17064.210665188115, -220528.59055385445, -1139334.4436798252, -2532523.0717758294, -2018891.4143353277};
        if (x < -34.0) {
            double q = -x;
            double w = Gamma.logGamma(q);
            double p = Math.floor(q);
            if (p == q) {
                throw new ArithmeticException("lgam: Overflow");
            }
            double z = q - p;
            if (z > 0.5) {
                z = (p += 1.0) - q;
            }
            if ((z = q * Math.sin(Math.PI * z)) == 0.0) {
                throw new ArithmeticException("lgamma: Overflow");
            }
            z = 1.1447298858494002 - Math.log(z) - w;
            return z;
        }
        if (x < 13.0) {
            double z = 1.0;
            while (x >= 3.0) {
                z *= (x -= 1.0);
            }
            while (x < 2.0) {
                if (x == 0.0) {
                    throw new ArithmeticException("lgamma: Overflow");
                }
                z /= x;
                x += 1.0;
            }
            if (z < 0.0) {
                z = -z;
            }
            if (x == 2.0) {
                return Math.log(z);
            }
            double p = (x -= 2.0) * Polynomial.polevl(x, bCoefficient, 5) / Polynomial.p1evl(x, cCoefficient, 6);
            return Math.log(z) + p;
        }
        if (x > 2.556348E305) {
            throw new ArithmeticException("lgamma: Overflow");
        }
        double q = (x - 0.5) * Math.log(x) - x + 0.9189385332046728;
        if (x > 1.0E8) {
            return q;
        }
        double p = 1.0 / (x * x);
        q = x >= 1000.0 ? (q += ((7.936507936507937E-4 * p - 0.002777777777777778) * p + 0.08333333333333333) / x) : (q += Polynomial.polevl(p, aCoefficient, 4) / x);
        return q;
    }

    private static double powerSeries(double a, double b, double x) {
        double v;
        double ai = 1.0 / a;
        double u = (1.0 - b) * x;
        double t1 = v = u / (a + 1.0);
        double t = u;
        double n = 2.0;
        double s = 0.0;
        double z = (double)1.110223E-16f * ai;
        while (Math.abs(v) > z) {
            u = (n - b) * x / n;
            v = (t *= u) / (a + n);
            s += v;
            n += 1.0;
        }
        s += t1;
        s += ai;
        u = a * Math.log(x);
        if (a + b < 171.6243769563027 && Math.abs(u) < 709.782712893384) {
            t = Gamma.gamma(a + b) / (Gamma.gamma(a) * Gamma.gamma(b));
            s = s * t * Math.pow(x, a);
        } else {
            t = Gamma.logGamma(a + b) - Gamma.logGamma(a) - Gamma.logGamma(b) + u + Math.log(s);
            s = t < -745.1332191019412 ? 0.0 : Math.exp(t);
        }
        return s;
    }

    static double stirlingFormula(double x) {
        double[] coefficients = new double[]{7.873113957930937E-4, -2.2954996161337813E-4, -0.0026813261780578124, 0.0034722222160545866, 0.08333333333334822};
        double w = 1.0 / x;
        double y = Math.exp(x);
        w = 1.0 + w * Polynomial.polevl(w, coefficients, 4);
        double MAXSTIR = 143.01608;
        if (x > MAXSTIR) {
            double v = Math.pow(x, 0.5 * x - 0.25);
            y = v * (v / y);
        } else {
            y = Math.pow(x, x - 0.5) / y;
        }
        y = 2.5066282746310007 * y * w;
        return y;
    }
}

