/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.matrix.impl.AbstractMatrix;

@Deprecated
public abstract class AbstractMatrix1D
extends AbstractMatrix {
    protected int size;
    protected int zero;
    protected int stride;

    protected AbstractMatrix1D() {
    }

    protected int offset(int absRank) {
        return absRank;
    }

    protected int rank(int rank) {
        return this.zero + rank * this.stride;
    }

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Attempted to access at index=" + index);
        }
    }

    protected void checkIndexes(int[] indexes) {
        int i = indexes.length;
        while (--i >= 0) {
            int index = indexes[i];
            if (index >= 0 && index < this.size) continue;
            this.checkIndex(index);
        }
    }

    protected void checkRange(int index, int width) {
        if (index < 0 || index + width > this.size) {
            throw new IndexOutOfBoundsException("index: " + index + ", width: " + width + ", size=" + this.size);
        }
    }

    protected void checkSize(double[] b) {
        if (this.size != b.length) {
            throw new IllegalArgumentException("Incompatible sizes: " + this.size + " and " + b.length);
        }
    }

    public void checkSize(AbstractMatrix1D b) {
        if (this.size != b.size) {
            throw new IllegalArgumentException("Incompatible sizes: " + this.size + " and " + b.size);
        }
    }

    protected int index(int rank) {
        return this.offset(this.rank(rank));
    }

    protected void setUp(int size) {
        this.setUp(size, 0, 1);
    }

    protected void setUp(int size, int zero, int stride) {
        if (size < 0) {
            throw new IllegalArgumentException("negative size");
        }
        this.size = size;
        this.zero = zero;
        this.stride = stride;
        this.isNoView = true;
    }

    public int size() {
        return this.size;
    }

    protected int stride(int dimension) {
        if (dimension != 0) {
            throw new IllegalArgumentException("invalid dimension: " + dimension);
        }
        return this.stride;
    }

    protected AbstractMatrix1D vFlip() {
        if (this.size > 0) {
            this.zero += (this.size - 1) * this.stride;
            this.stride = -this.stride;
            this.isNoView = false;
        }
        return this;
    }

    protected AbstractMatrix1D vPart(int index, int width) {
        this.checkRange(index, width);
        this.zero += this.stride * index;
        this.size = width;
        this.isNoView = false;
        return this;
    }

    protected AbstractMatrix1D vStrides(int stride) {
        if (stride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride: " + stride);
        }
        this.stride *= stride;
        if (this.size != 0) {
            this.size = (this.size - 1) / stride + 1;
        }
        this.isNoView = false;
        return this;
    }
}

