/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.impl;

import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.DelegateDoubleMatrix1D;

class WrapperDoubleMatrix2D
extends DoubleMatrix2D {
    private final DoubleMatrix2D content;

    WrapperDoubleMatrix2D(DoubleMatrix2D newContent) {
        if (newContent != null) {
            this.setUp(newContent.rows(), newContent.columns());
        }
        this.content = newContent;
    }

    protected DoubleMatrix2D getContent() {
        return this.content;
    }

    public double getQuick(int row, int column) {
        return this.content.getQuick(row, column);
    }

    public DoubleMatrix2D like(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    public DoubleMatrix1D like1D(int size) {
        return this.content.like1D(size);
    }

    protected DoubleMatrix1D like1D(int size, int offset, int stride) {
        throw new UnsupportedOperationException();
    }

    public void setQuick(int row, int column, double value) {
        this.content.setQuick(row, column, value);
    }

    public DoubleMatrix1D viewColumn(int column) {
        return this.viewDice().viewRow(column);
    }

    public DoubleMatrix2D viewColumnFlip() {
        if (this.columns == 0) {
            return this;
        }
        return new WrapperDoubleMatrix2D(this){

            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(row, this.columns - 1 - column);
            }

            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(row, this.columns - 1 - column, value);
            }
        };
    }

    public DoubleMatrix2D viewDice() {
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(column, row);
            }

            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(column, row, value);
            }
        };
        view.rows = this.columns;
        view.columns = this.rows;
        return view;
    }

    public DoubleMatrix2D viewPart(final int row, final int column, int height, int width) {
        this.checkBox(row, column, height, width);
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            public double getQuick(int i, int j) {
                return WrapperDoubleMatrix2D.this.content.get(row + i, column + j);
            }

            public void setQuick(int i, int j, double value) {
                WrapperDoubleMatrix2D.this.content.set(row + i, column + j, value);
            }
        };
        view.rows = height;
        view.columns = width;
        return view;
    }

    public DoubleMatrix1D viewRow(int row) {
        this.checkRow(row);
        return new DelegateDoubleMatrix1D(this, row);
    }

    public DoubleMatrix2D viewRowFlip() {
        if (this.rows == 0) {
            return this;
        }
        return new WrapperDoubleMatrix2D(this){

            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(this.rows - 1 - row, column);
            }

            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(this.rows - 1 - row, column, value);
            }
        };
    }

    public DoubleMatrix2D viewSelection(int[] rowIndexes, int[] columnIndexes) {
        int i;
        if (rowIndexes == null) {
            rowIndexes = new int[this.rows];
            i = this.rows;
            while (--i >= 0) {
                rowIndexes[i] = i;
            }
        }
        if (columnIndexes == null) {
            columnIndexes = new int[this.columns];
            i = this.columns;
            while (--i >= 0) {
                columnIndexes[i] = i;
            }
        }
        this.checkRowIndexes(rowIndexes);
        this.checkColumnIndexes(columnIndexes);
        final int[] rix = rowIndexes;
        final int[] cix = columnIndexes;
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            public double getQuick(int i, int j) {
                return WrapperDoubleMatrix2D.this.content.get(rix[i], cix[j]);
            }

            public void setQuick(int i, int j, double value) {
                WrapperDoubleMatrix2D.this.content.set(rix[i], cix[j], value);
            }
        };
        view.rows = rowIndexes.length;
        view.columns = columnIndexes.length;
        return view;
    }

    protected DoubleMatrix2D viewSelectionLike(int[] rowOffsets, int[] columnOffsets) {
        throw new UnsupportedOperationException();
    }

    public DoubleMatrix2D viewStrides(final int theRowStride, final int theColumnStride) {
        if (theRowStride <= 0 || theColumnStride <= 0) {
            throw new IndexOutOfBoundsException("illegal stride");
        }
        WrapperDoubleMatrix2D view = new WrapperDoubleMatrix2D(this){

            public double getQuick(int row, int column) {
                return WrapperDoubleMatrix2D.this.content.get(theRowStride * row, theColumnStride * column);
            }

            public void setQuick(int row, int column, double value) {
                WrapperDoubleMatrix2D.this.content.set(theRowStride * row, theColumnStride * column, value);
            }
        };
        view.rows = this.rows;
        view.columns = this.columns;
        if (this.rows != 0) {
            view.rows = (this.rows - 1) / theRowStride + 1;
        }
        if (this.columns != 0) {
            view.columns = (this.columns - 1) / theColumnStride + 1;
        }
        return view;
    }
}

