/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.linalg;

import org.apache.mahout.math.GenericPermuting;
import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.linalg.LUDecomposition;
import org.apache.mahout.math.matrix.linalg.Property;
import org.apache.mahout.math.matrix.linalg.QRDecomposition;

@Deprecated
public final class Algebra
extends PersistentObject {
    public static final Algebra DEFAULT = new Algebra();
    private static final Algebra ZERO;
    private Property property;

    public Algebra() {
        this(Property.DEFAULT.tolerance());
    }

    public Algebra(double tolerance) {
        this.setProperty(new Property(tolerance));
    }

    public Object clone() {
        return new Algebra(this.property.tolerance());
    }

    public static double det(DoubleMatrix2D A) {
        return Algebra.lu(A).det();
    }

    static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    private static LUDecomposition lu(DoubleMatrix2D matrix) {
        return new LUDecomposition(matrix);
    }

    public static DoubleMatrix1D permute(DoubleMatrix1D A, int[] indexes, double[] work) {
        int size = A.size();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        if (work == null || size > work.length) {
            work = A.toArray();
        } else {
            A.toArray(work);
        }
        int i = size;
        while (--i >= 0) {
            A.setQuick(i, work[indexes[i]]);
        }
        return A;
    }

    public static DoubleMatrix2D permute(DoubleMatrix2D A, int[] rowIndexes, int[] columnIndexes) {
        return A.viewSelection(rowIndexes, columnIndexes);
    }

    public static DoubleMatrix2D permuteColumns(DoubleMatrix2D A, int[] indexes, int[] work) {
        return Algebra.permuteRows(A.viewDice(), indexes, work);
    }

    public static DoubleMatrix2D permuteRows(final DoubleMatrix2D A, int[] indexes, int[] work) {
        int size = A.rows();
        if (indexes.length != size) {
            throw new IndexOutOfBoundsException("invalid permutation");
        }
        int columns = A.columns();
        if (columns < size / 10) {
            double[] doubleWork = new double[size];
            int j = A.columns();
            while (--j >= 0) {
                Algebra.permute(A.viewColumn(j), indexes, doubleWork);
            }
            return A;
        }
        Swapper swapper = new Swapper(){

            public void swap(int a, int b) {
                A.viewRow(a).swap(A.viewRow(b));
            }
        };
        GenericPermuting.permute(indexes, swapper, work, null);
        return A;
    }

    public Property property() {
        return this.property;
    }

    private static QRDecomposition qr(DoubleMatrix2D matrix) {
        return new QRDecomposition(matrix);
    }

    public void setProperty(Property property) {
        if (this == DEFAULT && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        if (this == ZERO && property != this.property) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.property = property;
    }

    public static DoubleMatrix2D solve(DoubleMatrix2D A, DoubleMatrix2D B) {
        return A.rows() == A.columns() ? Algebra.lu(A).solve(B) : Algebra.qr(A).solve(B);
    }

    static DoubleMatrix2D trapezoidalLower(DoubleMatrix2D A) {
        int rows = A.rows();
        int columns = A.columns();
        int r = rows;
        while (--r >= 0) {
            int c = columns;
            while (--c >= 0) {
                if (r >= c) continue;
                A.setQuick(r, c, 0.0);
            }
        }
        return A;
    }

    static {
        Algebra.DEFAULT.property = Property.DEFAULT;
        ZERO = new Algebra();
        Algebra.ZERO.property = Property.ZERO;
    }
}

