/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.linalg;

import java.io.Serializable;
import org.apache.mahout.math.matrix.DoubleFactory1D;
import org.apache.mahout.math.matrix.DoubleFactory2D;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.linalg.Algebra;
import org.apache.mahout.math.matrix.linalg.Property;

@Deprecated
public class EigenvalueDecomposition
implements Serializable {
    private final int n;
    private final double[] d;
    private final double[] e;
    private final double[][] V;
    private double[][] H;
    private double[] ort;
    private transient double cdivr;
    private transient double cdivi;

    public EigenvalueDecomposition(DoubleMatrix2D A) {
        Property.checkSquare(A);
        this.n = A.columns();
        this.V = new double[this.n][this.n];
        this.d = new double[this.n];
        this.e = new double[this.n];
        boolean issymmetric = Property.DEFAULT.isSymmetric(A);
        if (issymmetric) {
            for (int i = 0; i < this.n; ++i) {
                for (int j = 0; j < this.n; ++j) {
                    this.V[i][j] = A.getQuick(i, j);
                }
            }
            this.tred2();
            this.tql2();
        } else {
            this.H = new double[this.n][this.n];
            this.ort = new double[this.n];
            for (int j = 0; j < this.n; ++j) {
                for (int i = 0; i < this.n; ++i) {
                    this.H[i][j] = A.getQuick(i, j);
                }
            }
            this.orthes();
            this.hqr2();
        }
    }

    private void cdiv(double xr, double xi, double yr, double yi) {
        if (Math.abs(yr) > Math.abs(yi)) {
            double r = yi / yr;
            double d = yr + r * yi;
            this.cdivr = (xr + r * xi) / d;
            this.cdivi = (xi - r * xr) / d;
        } else {
            double r = yr / yi;
            double d = yi + r * yr;
            this.cdivr = (r * xr + xi) / d;
            this.cdivi = (r * xi - xr) / d;
        }
    }

    public DoubleMatrix2D getD() {
        double[][] D = new double[this.n][this.n];
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                D[i][j] = 0.0;
            }
            D[i][i] = this.d[i];
            if (this.e[i] > 0.0) {
                D[i][i + 1] = this.e[i];
                continue;
            }
            if (!(this.e[i] < 0.0)) continue;
            D[i][i - 1] = this.e[i];
        }
        return DoubleFactory2D.DENSE.make(D);
    }

    public DoubleMatrix1D getImagEigenvalues() {
        return DoubleFactory1D.dense.make(this.e);
    }

    public DoubleMatrix1D getRealEigenvalues() {
        return DoubleFactory1D.dense.make(this.d);
    }

    public DoubleMatrix2D getV() {
        return DoubleFactory2D.DENSE.make(this.V);
    }

    private void hqr2() {
        int k;
        int i;
        double x;
        double w;
        int nn = this.n;
        int n = nn - 1;
        int low = 0;
        int high = nn - 1;
        double eps = Math.pow(2.0, -52.0);
        double norm = 0.0;
        for (int i2 = 0; i2 < nn; ++i2) {
            if (i2 < low || i2 > high) {
                this.d[i2] = this.H[i2][i2];
                this.e[i2] = 0.0;
            }
            for (int j = Math.max(i2 - 1, 0); j < nn; ++j) {
                norm += Math.abs(this.H[i2][j]);
            }
        }
        int iter = 0;
        double z = 0.0;
        double s = 0.0;
        double r = 0.0;
        double q = 0.0;
        double p = 0.0;
        double exshift = 0.0;
        block2: while (n >= low) {
            int m;
            int l;
            for (l = n; l > low; --l) {
                s = Math.abs(this.H[l - 1][l - 1]) + Math.abs(this.H[l][l]);
                if (s == 0.0) {
                    s = norm;
                }
                if (Math.abs(this.H[l][l - 1]) < eps * s) break;
            }
            if (l == n) {
                double[] dArray = this.H[n];
                int n2 = n;
                dArray[n2] = dArray[n2] + exshift;
                this.d[n] = this.H[n][n];
                this.e[n] = 0.0;
                --n;
                iter = 0;
                continue;
            }
            if (l == n - 1) {
                w = this.H[n][n - 1] * this.H[n - 1][n];
                p = (this.H[n - 1][n - 1] - this.H[n][n]) / 2.0;
                q = p * p + w;
                z = Math.sqrt(Math.abs(q));
                double[] dArray = this.H[n];
                int n3 = n;
                dArray[n3] = dArray[n3] + exshift;
                double[] dArray2 = this.H[n - 1];
                int n4 = n - 1;
                dArray2[n4] = dArray2[n4] + exshift;
                x = this.H[n][n];
                if (q >= 0.0) {
                    z = p >= 0.0 ? p + z : p - z;
                    this.d[n - 1] = x + z;
                    this.d[n] = this.d[n - 1];
                    if (z != 0.0) {
                        this.d[n] = x - w / z;
                    }
                    this.e[n - 1] = 0.0;
                    this.e[n] = 0.0;
                    x = this.H[n][n - 1];
                    s = Math.abs(x) + Math.abs(z);
                    p = x / s;
                    q = z / s;
                    r = Math.sqrt(p * p + q * q);
                    p /= r;
                    q /= r;
                    for (int j = n - 1; j < nn; ++j) {
                        z = this.H[n - 1][j];
                        this.H[n - 1][j] = q * z + p * this.H[n][j];
                        this.H[n][j] = q * this.H[n][j] - p * z;
                    }
                    for (i = 0; i <= n; ++i) {
                        z = this.H[i][n - 1];
                        this.H[i][n - 1] = q * z + p * this.H[i][n];
                        this.H[i][n] = q * this.H[i][n] - p * z;
                    }
                    for (i = low; i <= high; ++i) {
                        z = this.V[i][n - 1];
                        this.V[i][n - 1] = q * z + p * this.V[i][n];
                        this.V[i][n] = q * this.V[i][n] - p * z;
                    }
                } else {
                    this.d[n - 1] = x + p;
                    this.d[n] = x + p;
                    this.e[n - 1] = z;
                    this.e[n] = -z;
                }
                n -= 2;
                iter = 0;
                continue;
            }
            x = this.H[n][n];
            double y = 0.0;
            w = 0.0;
            if (l < n) {
                y = this.H[n - 1][n - 1];
                w = this.H[n][n - 1] * this.H[n - 1][n];
            }
            if (iter == 10) {
                exshift += x;
                i = low;
                while (i <= n) {
                    double[] dArray = this.H[i];
                    int n5 = i++;
                    dArray[n5] = dArray[n5] - x;
                }
                s = Math.abs(this.H[n][n - 1]) + Math.abs(this.H[n - 1][n - 2]);
                x = y = 0.75 * s;
                w = -0.4375 * s * s;
            }
            if (iter == 30) {
                s = (y - x) / 2.0;
                if ((s = s * s + w) > 0.0) {
                    s = Math.sqrt(s);
                    if (y < x) {
                        s = -s;
                    }
                    s = x - w / ((y - x) / 2.0 + s);
                    i = low;
                    while (i <= n) {
                        double[] dArray = this.H[i];
                        int n6 = i++;
                        dArray[n6] = dArray[n6] - s;
                    }
                    exshift += s;
                    w = 0.964;
                    y = 0.964;
                    x = 0.964;
                }
            }
            ++iter;
            for (m = n - 2; m >= l; --m) {
                z = this.H[m][m];
                r = x - z;
                s = y - z;
                p = (r * s - w) / this.H[m + 1][m] + this.H[m][m + 1];
                q = this.H[m + 1][m + 1] - z - r - s;
                r = this.H[m + 2][m + 1];
                s = Math.abs(p) + Math.abs(q) + Math.abs(r);
                if (m == l || Math.abs(this.H[m][m - 1]) * (Math.abs(q /= s) + Math.abs(r /= s)) < eps * (Math.abs(p /= s) * (Math.abs(this.H[m - 1][m - 1]) + Math.abs(z) + Math.abs(this.H[m + 1][m + 1])))) break;
            }
            for (int i3 = m + 2; i3 <= n; ++i3) {
                this.H[i3][i3 - 2] = 0.0;
                if (i3 <= m + 2) continue;
                this.H[i3][i3 - 3] = 0.0;
            }
            for (k = m; k <= n - 1; ++k) {
                int i4;
                boolean notlast;
                boolean bl = notlast = k != n - 1;
                if (k != m) {
                    p = this.H[k][k - 1];
                    q = this.H[k + 1][k - 1];
                    r = notlast ? this.H[k + 2][k - 1] : 0.0;
                    x = Math.abs(p) + Math.abs(q) + Math.abs(r);
                    if (x != 0.0) {
                        p /= x;
                        q /= x;
                        r /= x;
                    }
                }
                if (x == 0.0) continue block2;
                s = Math.sqrt(p * p + q * q + r * r);
                if (p < 0.0) {
                    s = -s;
                }
                if (s == 0.0) continue;
                if (k != m) {
                    this.H[k][k - 1] = -s * x;
                } else if (l != m) {
                    this.H[k][k - 1] = -this.H[k][k - 1];
                }
                x = (p += s) / s;
                y = q / s;
                z = r / s;
                q /= p;
                r /= p;
                int j = k;
                while (j < nn) {
                    p = this.H[k][j] + q * this.H[k + 1][j];
                    if (notlast) {
                        double[] dArray = this.H[k + 2];
                        int n7 = j;
                        dArray[n7] = dArray[n7] - (p += r * this.H[k + 2][j]) * z;
                    }
                    double[] dArray = this.H[k];
                    int n8 = j;
                    dArray[n8] = dArray[n8] - p * x;
                    double[] dArray3 = this.H[k + 1];
                    int n9 = j++;
                    dArray3[n9] = dArray3[n9] - p * y;
                }
                for (i4 = 0; i4 <= Math.min(n, k + 3); ++i4) {
                    p = x * this.H[i4][k] + y * this.H[i4][k + 1];
                    if (notlast) {
                        double[] dArray = this.H[i4];
                        int n10 = k + 2;
                        dArray[n10] = dArray[n10] - (p += z * this.H[i4][k + 2]) * r;
                    }
                    double[] dArray = this.H[i4];
                    int n11 = k;
                    dArray[n11] = dArray[n11] - p;
                    double[] dArray4 = this.H[i4];
                    int n12 = k + 1;
                    dArray4[n12] = dArray4[n12] - p * q;
                }
                for (i4 = low; i4 <= high; ++i4) {
                    p = x * this.V[i4][k] + y * this.V[i4][k + 1];
                    if (notlast) {
                        double[] dArray = this.V[i4];
                        int n13 = k + 2;
                        dArray[n13] = dArray[n13] - (p += z * this.V[i4][k + 2]) * r;
                    }
                    double[] dArray = this.V[i4];
                    int n14 = k;
                    dArray[n14] = dArray[n14] - p;
                    double[] dArray5 = this.V[i4];
                    int n15 = k + 1;
                    dArray5[n15] = dArray5[n15] - p * q;
                }
            }
        }
        if (norm == 0.0) {
            return;
        }
        for (n = nn - 1; n >= 0; --n) {
            double t;
            double y;
            int i5;
            int l;
            p = this.d[n];
            q = this.e[n];
            if (q == 0.0) {
                l = n;
                this.H[n][n] = 1.0;
                for (i5 = n - 1; i5 >= 0; --i5) {
                    int j;
                    w = this.H[i5][i5] - p;
                    r = 0.0;
                    for (j = l; j <= n; ++j) {
                        r += this.H[i5][j] * this.H[j][n];
                    }
                    if (this.e[i5] < 0.0) {
                        z = w;
                        s = r;
                        continue;
                    }
                    l = i5;
                    if (this.e[i5] == 0.0) {
                        this.H[i5][n] = w != 0.0 ? -r / w : -r / (eps * norm);
                    } else {
                        x = this.H[i5][i5 + 1];
                        y = this.H[i5 + 1][i5];
                        q = (this.d[i5] - p) * (this.d[i5] - p) + this.e[i5] * this.e[i5];
                        this.H[i5][n] = t = (x * s - z * r) / q;
                        this.H[i5 + 1][n] = Math.abs(x) > Math.abs(z) ? (-r - w * t) / x : (-s - y * t) / z;
                    }
                    t = Math.abs(this.H[i5][n]);
                    if (!(eps * t * t > 1.0)) continue;
                    for (j = i5; j <= n; ++j) {
                        double[] dArray = this.H[j];
                        int n16 = n;
                        dArray[n16] = dArray[n16] / t;
                    }
                }
                continue;
            }
            if (!(q < 0.0)) continue;
            l = n - 1;
            if (Math.abs(this.H[n][n - 1]) > Math.abs(this.H[n - 1][n])) {
                this.H[n - 1][n - 1] = q / this.H[n][n - 1];
                this.H[n - 1][n] = -(this.H[n][n] - p) / this.H[n][n - 1];
            } else {
                this.cdiv(0.0, -this.H[n - 1][n], this.H[n - 1][n - 1] - p, q);
                this.H[n - 1][n - 1] = this.cdivr;
                this.H[n - 1][n] = this.cdivi;
            }
            this.H[n][n - 1] = 0.0;
            this.H[n][n] = 1.0;
            for (i5 = n - 2; i5 >= 0; --i5) {
                int j;
                double ra = 0.0;
                double sa = 0.0;
                for (j = l; j <= n; ++j) {
                    ra += this.H[i5][j] * this.H[j][n - 1];
                    sa += this.H[i5][j] * this.H[j][n];
                }
                w = this.H[i5][i5] - p;
                if (this.e[i5] < 0.0) {
                    z = w;
                    r = ra;
                    s = sa;
                    continue;
                }
                l = i5;
                if (this.e[i5] == 0.0) {
                    this.cdiv(-ra, -sa, w, q);
                    this.H[i5][n - 1] = this.cdivr;
                    this.H[i5][n] = this.cdivi;
                } else {
                    x = this.H[i5][i5 + 1];
                    y = this.H[i5 + 1][i5];
                    double vr = (this.d[i5] - p) * (this.d[i5] - p) + this.e[i5] * this.e[i5] - q * q;
                    double vi = (this.d[i5] - p) * 2.0 * q;
                    if (vr == 0.0 && vi == 0.0) {
                        vr = eps * norm * (Math.abs(w) + Math.abs(q) + Math.abs(x) + Math.abs(y) + Math.abs(z));
                    }
                    this.cdiv(x * r - z * ra + q * sa, x * s - z * sa - q * ra, vr, vi);
                    this.H[i5][n - 1] = this.cdivr;
                    this.H[i5][n] = this.cdivi;
                    if (Math.abs(x) > Math.abs(z) + Math.abs(q)) {
                        this.H[i5 + 1][n - 1] = (-ra - w * this.H[i5][n - 1] + q * this.H[i5][n]) / x;
                        this.H[i5 + 1][n] = (-sa - w * this.H[i5][n] - q * this.H[i5][n - 1]) / x;
                    } else {
                        this.cdiv(-r - y * this.H[i5][n - 1], -s - y * this.H[i5][n], z, q);
                        this.H[i5 + 1][n - 1] = this.cdivr;
                        this.H[i5 + 1][n] = this.cdivi;
                    }
                }
                t = Math.max(Math.abs(this.H[i5][n - 1]), Math.abs(this.H[i5][n]));
                if (!(eps * t * t > 1.0)) continue;
                for (j = i5; j <= n; ++j) {
                    double[] dArray = this.H[j];
                    int n17 = n - 1;
                    dArray[n17] = dArray[n17] / t;
                    double[] dArray6 = this.H[j];
                    int n18 = n;
                    dArray6[n18] = dArray6[n18] / t;
                }
            }
        }
        for (int i6 = 0; i6 < nn; ++i6) {
            if (i6 >= low && i6 <= high) continue;
            System.arraycopy(this.H[i6], i6, this.V[i6], i6, nn - i6);
        }
        for (int j = nn - 1; j >= low; --j) {
            for (i = low; i <= high; ++i) {
                z = 0.0;
                for (k = low; k <= Math.min(j, high); ++k) {
                    z += this.V[i][k] * this.H[k][j];
                }
                this.V[i][j] = z;
            }
        }
    }

    private void orthes() {
        int m;
        int low = 0;
        int high = this.n - 1;
        for (m = low + 1; m <= high - 1; ++m) {
            double f;
            double scale = 0.0;
            for (int i = m; i <= high; ++i) {
                scale += Math.abs(this.H[i][m - 1]);
            }
            if (scale == 0.0) continue;
            double h = 0.0;
            for (int i = high; i >= m; --i) {
                this.ort[i] = this.H[i][m - 1] / scale;
                h += this.ort[i] * this.ort[i];
            }
            double g = Math.sqrt(h);
            if (this.ort[m] > 0.0) {
                g = -g;
            }
            h -= this.ort[m] * g;
            int n = m;
            this.ort[n] = this.ort[n] - g;
            for (int j = m; j < this.n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m; --i) {
                    f += this.ort[i] * this.H[i][j];
                }
                f /= h;
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.H[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - f * this.ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m; --j) {
                    f += this.ort[j] * this.H[i][j];
                }
                f /= h;
                for (j = m; j <= high; ++j) {
                    double[] dArray = this.H[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - f * this.ort[j];
                }
            }
            this.ort[m] = scale * this.ort[m];
            this.H[m][m - 1] = scale * g;
        }
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                this.V[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (m = high - 1; m >= low + 1; --m) {
            if (this.H[m][m - 1] == 0.0) continue;
            for (int i = m + 1; i <= high; ++i) {
                this.ort[i] = this.H[i][m - 1];
            }
            for (int j = m; j <= high; ++j) {
                int i;
                double g = 0.0;
                for (i = m; i <= high; ++i) {
                    g += this.ort[i] * this.V[i][j];
                }
                g = g / this.ort[m] / this.H[m][m - 1];
                for (i = m; i <= high; ++i) {
                    double[] dArray = this.V[i];
                    int n = j;
                    dArray[n] = dArray[n] + g * this.ort[i];
                }
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("---------------------------------------------------------------------\n");
        buf.append("EigenvalueDecomposition(A) --> D, V, realEigenvalues, imagEigenvalues\n");
        buf.append("---------------------------------------------------------------------\n");
        buf.append("realEigenvalues = ");
        String unknown = "Illegal operation or error: ";
        try {
            buf.append(String.valueOf((Object)this.getRealEigenvalues()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\nimagEigenvalues = ");
        try {
            buf.append(String.valueOf((Object)this.getImagEigenvalues()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\nD = ");
        try {
            buf.append(String.valueOf((Object)this.getD()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        buf.append("\n\nV = ");
        try {
            buf.append(String.valueOf((Object)this.getV()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown).append(exc.getMessage());
        }
        return buf.toString();
    }

    private void tql2() {
        System.arraycopy(this.e, 1, this.e, 0, this.n - 1);
        this.e[this.n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < this.n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(this.d[l]) + Math.abs(this.e[l]));
            for (m = l; m < this.n && !(Math.abs(this.e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = this.d[l];
                    double p = (this.d[l + 1] - g) / (2.0 * this.e[l]);
                    double r = Algebra.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    this.d[l] = this.e[l] / (p + r);
                    this.d[l + 1] = this.e[l] * (p + r);
                    double dl1 = this.d[l + 1];
                    double h = g - this.d[l];
                    int i = l + 2;
                    while (i < this.n) {
                        int n = i++;
                        this.d[n] = this.d[n] - h;
                    }
                    f += h;
                    p = this.d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = this.e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * this.e[i2];
                        h = c * p;
                        r = Algebra.hypot(p, this.e[i2]);
                        this.e[i2 + 1] = s * r;
                        s = this.e[i2] / r;
                        c = p / r;
                        p = c * this.d[i2] - s * g;
                        this.d[i2 + 1] = h + s * (c * g + s * this.d[i2]);
                        for (int k = 0; k < this.n; ++k) {
                            h = this.V[k][i2 + 1];
                            this.V[k][i2 + 1] = s * this.V[k][i2] + c * h;
                            this.V[k][i2] = c * this.V[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * this.e[l] / dl1;
                    this.e[l] = s * p;
                    this.d[l] = c * p;
                } while (Math.abs(this.e[l]) > eps * tst1);
            }
            int n = l;
            this.d[n] = this.d[n] + f;
            this.e[l] = 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            int j;
            int k = i;
            double p = this.d[i];
            for (j = i + 1; j < this.n; ++j) {
                if (!(this.d[j] < p)) continue;
                k = j;
                p = this.d[j];
            }
            if (k == i) continue;
            this.d[k] = this.d[i];
            this.d[i] = p;
            for (j = 0; j < this.n; ++j) {
                p = this.V[j][i];
                this.V[j][i] = this.V[j][k];
                this.V[j][k] = p;
            }
        }
    }

    private void tred2() {
        int i;
        System.arraycopy(this.V[this.n - 1], 0, this.d, 0, this.n);
        for (i = this.n - 1; i > 0; --i) {
            double scale = 0.0;
            for (int k = 0; k < i; ++k) {
                scale += Math.abs(this.d[k]);
            }
            double h = 0.0;
            if (scale == 0.0) {
                this.e[i] = this.d[i - 1];
                for (int j = 0; j < i; ++j) {
                    this.d[j] = this.V[i - 1][j];
                    this.V[i][j] = 0.0;
                    this.V[j][i] = 0.0;
                }
            } else {
                int j;
                int j2;
                for (int k = 0; k < i; ++k) {
                    int n = k;
                    this.d[n] = this.d[n] / scale;
                    h += this.d[k] * this.d[k];
                }
                double f = this.d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                this.e[i] = scale * g;
                h -= f * g;
                this.d[i - 1] = f - g;
                for (j2 = 0; j2 < i; ++j2) {
                    this.e[j2] = 0.0;
                }
                for (j2 = 0; j2 < i; ++j2) {
                    this.V[j2][i] = f = this.d[j2];
                    g = this.e[j2] + this.V[j2][j2] * f;
                    for (int k = j2 + 1; k <= i - 1; ++k) {
                        g += this.V[k][j2] * this.d[k];
                        int n = k;
                        this.e[n] = this.e[n] + this.V[k][j2] * f;
                    }
                    this.e[j2] = g;
                }
                f = 0.0;
                for (j2 = 0; j2 < i; ++j2) {
                    int n = j2;
                    this.e[n] = this.e[n] / h;
                    f += this.e[j2] * this.d[j2];
                }
                double hh = f / (h + h);
                for (j = 0; j < i; ++j) {
                    int n = j;
                    this.e[n] = this.e[n] - hh * this.d[j];
                }
                for (j = 0; j < i; ++j) {
                    f = this.d[j];
                    g = this.e[j];
                    for (int k = j; k <= i - 1; ++k) {
                        double[] dArray = this.V[k];
                        int n = j;
                        dArray[n] = dArray[n] - (f * this.e[k] + g * this.d[k]);
                    }
                    this.d[j] = this.V[i - 1][j];
                    this.V[i][j] = 0.0;
                }
            }
            this.d[i] = h;
        }
        for (i = 0; i < this.n - 1; ++i) {
            int k;
            this.V[this.n - 1][i] = this.V[i][i];
            this.V[i][i] = 1.0;
            double h = this.d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    this.d[k] = this.V[k][i + 1] / h;
                }
                for (int j = 0; j <= i; ++j) {
                    int k2;
                    double g = 0.0;
                    for (k2 = 0; k2 <= i; ++k2) {
                        g += this.V[k2][i + 1] * this.V[k2][j];
                    }
                    for (k2 = 0; k2 <= i; ++k2) {
                        double[] dArray = this.V[k2];
                        int n = j;
                        dArray[n] = dArray[n] - g * this.d[k2];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                this.V[k][i + 1] = 0.0;
            }
        }
        for (int j = 0; j < this.n; ++j) {
            this.d[j] = this.V[this.n - 1][j];
            this.V[this.n - 1][j] = 0.0;
        }
        this.V[this.n - 1][this.n - 1] = 1.0;
        this.e[0] = 0.0;
    }
}

