/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.matrix.linalg;

import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.mahout.math.PersistentObject;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.list.ObjectArrayList;
import org.apache.mahout.math.matrix.DoubleFactory2D;
import org.apache.mahout.math.matrix.DoubleMatrix1D;
import org.apache.mahout.math.matrix.DoubleMatrix2D;
import org.apache.mahout.math.matrix.impl.AbstractMatrix2D;
import org.apache.mahout.math.matrix.linalg.Algebra;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class Property
extends PersistentObject {
    public static final Property DEFAULT = new Property(1.0E-9);
    public static final Property ZERO = new Property(0.0);
    public static final Property TWELVE = new Property(1.0E-12);
    private double tolerance;

    private Property() {
        this(1.0E-9);
    }

    public Property(double newTolerance) {
        this.tolerance = Math.abs(newTolerance);
    }

    protected static String blanks(int length) {
        if (length < 0) {
            length = 0;
        }
        StringBuilder buf = new StringBuilder(length);
        for (int k = 0; k < length; ++k) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static void checkRectangular(AbstractMatrix2D a) {
        if (a.rows() < a.columns()) {
            throw new IllegalArgumentException("Matrix must be rectangular");
        }
    }

    public static void checkSquare(AbstractMatrix2D a) {
        if (a.rows() != a.columns()) {
            throw new IllegalArgumentException("Matrix must be square");
        }
    }

    public static double density(DoubleMatrix2D a) {
        return (double)a.cardinality() / (double)a.size();
    }

    public boolean equals(DoubleMatrix1D a, double value) {
        if (a == null) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = a.size();
        while (--i >= 0) {
            double x = a.getQuick(i);
            double diff = Math.abs(value - x);
            if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                diff = 0.0;
            }
            if (!(diff > epsilon)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix1D a, DoubleMatrix1D b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        double epsilon = this.tolerance();
        int i = size;
        while (--i >= 0) {
            double x = a.getQuick(i);
            double value = b.getQuick(i);
            double diff = Math.abs(value - x);
            if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                diff = 0.0;
            }
            if (diff <= epsilon) continue;
            return false;
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D a, double value) {
        if (a == null) {
            return false;
        }
        int rows = a.rows();
        int columns = a.columns();
        double epsilon = this.tolerance();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double x = a.getQuick(row, column);
                double diff = Math.abs(value - x);
                if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                    diff = 0.0;
                }
                if (diff <= epsilon) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(DoubleMatrix2D a, DoubleMatrix2D b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int rows = a.rows();
        int columns = a.columns();
        if (columns != b.columns() || rows != b.rows()) {
            return false;
        }
        double epsilon = this.tolerance();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double x = a.getQuick(row, column);
                double value = b.getQuick(row, column);
                double diff = Math.abs(value - x);
                if (Double.isNaN(diff) && (Double.isNaN(value) && Double.isNaN(x) || value == x)) {
                    diff = 0.0;
                }
                if (!(diff > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static void generateNonSingular(DoubleMatrix2D a) {
        int min;
        Property.checkSquare(a);
        int i = min = Math.min(a.rows(), a.columns());
        while (--i >= 0) {
            a.setQuick(i, i, 0.0);
        }
        i = min;
        while (--i >= 0) {
            double rowSum = a.viewRow(i).aggregate(Functions.PLUS, Functions.ABS);
            double colSum = a.viewColumn(i).aggregate(Functions.PLUS, Functions.ABS);
            a.setQuick(i, i, Math.max(rowSum, colSum) + (double)i + 1.0);
        }
    }

    protected static String get(ObjectArrayList<String> list, int index) {
        return (String)list.get(index);
    }

    public boolean isDiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isDiagonallyDominantByColumn(DoubleMatrix2D a) {
        int min;
        int i = min = Math.min(a.rows(), a.columns());
        while (--i >= 0) {
            double diag = Math.abs(a.getQuick(i, i));
            if (!((diag += diag) <= a.viewColumn(i).aggregate(Functions.PLUS, Functions.ABS))) continue;
            return false;
        }
        return true;
    }

    public static boolean isDiagonallyDominantByRow(DoubleMatrix2D a) {
        int min;
        int i = min = Math.min(a.rows(), a.columns());
        while (--i >= 0) {
            double diag = Math.abs(a.getQuick(i, i));
            if (!((diag += diag) <= a.viewRow(i).aggregate(Functions.PLUS, Functions.ABS))) continue;
            return false;
        }
        return true;
    }

    public boolean isIdentity(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                double v = a.getQuick(row, column);
                if (!(row == column ? Math.abs(1.0 - v) > epsilon : Math.abs(v) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerBidiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column + 1 || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLowerTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = Math.min(column, rows);
            while (--row >= 0) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isNonNegative(DoubleMatrix2D a) {
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (!(a.getQuick(row, column) < 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isOrthogonal(DoubleMatrix2D a) {
        Property.checkSquare(a);
        return this.equals(a.zMult(a, null, 1.0, 0.0, false, true), DoubleFactory2D.DENSE.identity(a.rows()));
    }

    public static boolean isPositive(DoubleMatrix2D a) {
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (!(a.getQuick(row, column) <= 0.0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSingular(DoubleMatrix2D a) {
        return Math.abs(Algebra.det(a)) < this.tolerance();
    }

    public boolean isSkewSymmetric(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int row = rows = a.rows();
        while (--row >= 0) {
            int column = rows;
            while (--column >= 0) {
                if (!(Math.abs(a.getQuick(row, column) + a.getQuick(column, row)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isSquare(AbstractMatrix2D a) {
        return a.rows() == a.columns();
    }

    public boolean isStrictlyLowerTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = Math.min(rows, column + 1);
            while (--row >= 0) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isStrictlyTriangular(DoubleMatrix2D a) {
        if (this.isTriangular(a)) {
            double epsilon = this.tolerance();
            int i = Math.min(a.rows(), a.columns());
            while (--i >= 0) {
                if (!(Math.abs(a.getQuick(i, i)) > epsilon)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isStrictlyUpperTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row >= column) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSymmetric(DoubleMatrix2D a) {
        Property.checkSquare(a);
        return this.equals(a, a.viewDice());
    }

    public boolean isTriangular(DoubleMatrix2D a) {
        return this.isLowerTriangular(a) || this.isUpperTriangular(a);
    }

    public boolean isTridiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (Math.abs(row - column) <= 1 || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUnitTriangular(DoubleMatrix2D a) {
        if (this.isTriangular(a)) {
            double epsilon = this.tolerance();
            int i = Math.min(a.rows(), a.columns());
            while (--i >= 0) {
                if (!(Math.abs(1.0 - a.getQuick(i, i)) > epsilon)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isUpperBidiagonal(DoubleMatrix2D a) {
        double epsilon = this.tolerance();
        int rows = a.rows();
        int columns = a.columns();
        int row = rows;
        while (--row >= 0) {
            int column = columns;
            while (--column >= 0) {
                if (row == column || row == column - 1 || !(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isUpperTriangular(DoubleMatrix2D a) {
        int columns;
        double epsilon = this.tolerance();
        int rows = a.rows();
        int column = columns = a.columns();
        while (--column >= 0) {
            int row = rows;
            while (--row > column) {
                if (!(Math.abs(a.getQuick(row, column)) > epsilon)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isZero(DoubleMatrix2D a) {
        return this.equals(a, 0.0);
    }

    public int lowerBandwidth(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int k = rows = a.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(a.getQuick(j, i)) > epsilon)) continue;
                return k;
            }
        }
        return 0;
    }

    public int semiBandwidth(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int k = rows = a.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (!(Math.abs(a.getQuick(j, i)) <= epsilon)) {
                    return k + 1;
                }
                if (!(Math.abs(a.getQuick(i, j)) > epsilon)) continue;
                return k + 1;
            }
        }
        return 1;
    }

    public void setTolerance(double newTolerance) {
        if (this == DEFAULT || this == ZERO || this == TWELVE) {
            throw new IllegalArgumentException("Attempted to modify immutable object.");
        }
        this.tolerance = Math.abs(newTolerance);
    }

    public double tolerance() {
        return this.tolerance;
    }

    public String toString(DoubleMatrix2D a) {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        String name = "density";
        String unknown = "Illegal operation or error: ";
        try {
            messages.put(name, String.valueOf(Property.density(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isDiagonal";
        try {
            messages.put(name, String.valueOf(this.isDiagonal(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isDiagonallyDominantByRow";
        try {
            messages.put(name, String.valueOf(Property.isDiagonallyDominantByRow(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isDiagonallyDominantByColumn";
        try {
            messages.put(name, String.valueOf(Property.isDiagonallyDominantByColumn(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isIdentity";
        try {
            messages.put(name, String.valueOf(this.isIdentity(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isLowerBidiagonal";
        try {
            messages.put(name, String.valueOf(this.isLowerBidiagonal(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isLowerTriangular";
        try {
            messages.put(name, String.valueOf(this.isLowerTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isNonNegative";
        try {
            messages.put(name, String.valueOf(Property.isNonNegative(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isOrthogonal";
        try {
            messages.put(name, String.valueOf(this.isOrthogonal(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isPositive";
        try {
            messages.put(name, String.valueOf(Property.isPositive(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isSingular";
        try {
            messages.put(name, String.valueOf(this.isSingular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isSkewSymmetric";
        try {
            messages.put(name, String.valueOf(this.isSkewSymmetric(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isSquare";
        try {
            messages.put(name, String.valueOf(Property.isSquare(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isStrictlyLowerTriangular";
        try {
            messages.put(name, String.valueOf(this.isStrictlyLowerTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isStrictlyTriangular";
        try {
            messages.put(name, String.valueOf(this.isStrictlyTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isStrictlyUpperTriangular";
        try {
            messages.put(name, String.valueOf(this.isStrictlyUpperTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isSymmetric";
        try {
            messages.put(name, String.valueOf(this.isSymmetric(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isTriangular";
        try {
            messages.put(name, String.valueOf(this.isTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isTridiagonal";
        try {
            messages.put(name, String.valueOf(this.isTridiagonal(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isUnitTriangular";
        try {
            messages.put(name, String.valueOf(this.isUnitTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isUpperBidiagonal";
        try {
            messages.put(name, String.valueOf(this.isUpperBidiagonal(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isUpperTriangular";
        try {
            messages.put(name, String.valueOf(this.isUpperTriangular(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "isZero";
        try {
            messages.put(name, String.valueOf(this.isZero(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "lowerBandwidth";
        try {
            messages.put(name, String.valueOf(this.lowerBandwidth(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "semiBandwidth";
        try {
            messages.put(name, String.valueOf(this.semiBandwidth(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        name = "upperBandwidth";
        try {
            messages.put(name, String.valueOf(this.upperBandwidth(a)));
        }
        catch (IllegalArgumentException exc) {
            messages.put(name, unknown + exc.getMessage());
        }
        int maxLength = 0;
        for (String key : messages.keySet()) {
            maxLength = Math.max(key.length(), maxLength);
        }
        String format = String.format(Locale.ENGLISH, "\\%%ds: \\%s\n", maxLength);
        Formatter r = new Formatter();
        for (Map.Entry entry : messages.entrySet()) {
            r.format(format, maxLength, entry.getKey(), entry.getValue());
        }
        return r.toString();
    }

    public int upperBandwidth(DoubleMatrix2D a) {
        int rows;
        Property.checkSquare(a);
        double epsilon = this.tolerance();
        int k = rows = a.rows();
        while (--k >= 0) {
            int i = rows - k;
            while (--i >= 0) {
                int j = i + k;
                if (Math.abs(a.getQuick(i, j)) <= epsilon) continue;
                return k;
            }
        }
        return 0;
    }
}

