/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

public final class LogLikelihood {
    private LogLikelihood() {
    }

    public static double entropy(int ... elements) {
        double sum = 0.0;
        double result = 0.0;
        for (int element : elements) {
            if (element < 0) {
                throw new IllegalArgumentException("Should not have negative count for entropy computation: (" + element + ')');
            }
            if (element <= 0) continue;
            result += (double)element * Math.log(element);
            sum += (double)element;
        }
        return -(result -= sum * Math.log(sum));
    }

    public static double logLikelihoodRatio(int k11, int k12, int k21, int k22) {
        double rowEntropy = LogLikelihood.entropy(k11, k12) + LogLikelihood.entropy(k21, k22);
        double columnEntropy = LogLikelihood.entropy(k11, k21) + LogLikelihood.entropy(k12, k22);
        int[] nArray = new int[]{k11, k12, k21, k22};
        double matrixEntropy = LogLikelihood.entropy(nArray);
        if (rowEntropy + columnEntropy > matrixEntropy) {
            return 0.0;
        }
        return 2.0 * (matrixEntropy - rowEntropy - columnEntropy);
    }

    public static double rootLogLikelihoodRatio(int k11, int k12, int k21, int k22) {
        double llr = LogLikelihood.logLikelihoodRatio(k11, k12, k21, k22);
        double sqrt = Math.sqrt(llr);
        if ((double)k11 / (double)(k11 + k12) < (double)k21 / (double)(k21 + k22)) {
            sqrt = -sqrt;
        }
        return sqrt;
    }
}

