/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.MatrixVectorView;
import org.apache.mahout.math.UnboundLabelException;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.VectorFunction;

public abstract class AbstractMatrix
implements Matrix {
    protected Map<String, Integer> columnLabelBindings;
    protected Map<String, Integer> rowLabelBindings;
    protected int[] cardinality = new int[2];
    public static final int COL = 1;
    public static final int ROW = 0;

    @Override
    public int columnSize() {
        return this.cardinality[1];
    }

    @Override
    public int rowSize() {
        return this.cardinality[0];
    }

    @Override
    public int[] size() {
        return this.cardinality;
    }

    @Override
    public Iterator<MatrixSlice> iterator() {
        return this.iterateAll();
    }

    @Override
    public Iterator<MatrixSlice> iterateAll() {
        return new Iterator<MatrixSlice>(){
            private int slice;

            @Override
            public boolean hasNext() {
                return this.slice < AbstractMatrix.this.numSlices();
            }

            @Override
            public MatrixSlice next() {
                if (this.slice >= AbstractMatrix.this.numSlices()) {
                    throw new NoSuchElementException();
                }
                int i = this.slice++;
                return new MatrixSlice(AbstractMatrix.this.slice(i), i);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported for Matrix iterator");
            }
        };
    }

    protected Vector slice(int index) {
        return this.getRow(index);
    }

    @Override
    public int numSlices() {
        return this.numRows();
    }

    @Override
    public double get(String rowLabel, String columnLabel) {
        if (this.columnLabelBindings == null || this.rowLabelBindings == null) {
            throw new UnboundLabelException();
        }
        Integer row = this.rowLabelBindings.get(rowLabel);
        Integer col = this.columnLabelBindings.get(columnLabel);
        if (row == null || col == null) {
            throw new UnboundLabelException();
        }
        return this.get(row, col);
    }

    @Override
    public Map<String, Integer> getColumnLabelBindings() {
        return this.columnLabelBindings;
    }

    @Override
    public Map<String, Integer> getRowLabelBindings() {
        return this.rowLabelBindings;
    }

    @Override
    public void set(String rowLabel, double[] rowData) {
        if (this.columnLabelBindings == null) {
            throw new UnboundLabelException();
        }
        Integer row = this.rowLabelBindings.get(rowLabel);
        if (row == null) {
            throw new UnboundLabelException();
        }
        this.set(row, rowData);
    }

    @Override
    public void set(String rowLabel, int row, double[] rowData) {
        if (this.rowLabelBindings == null) {
            this.rowLabelBindings = new HashMap<String, Integer>();
        }
        this.rowLabelBindings.put(rowLabel, row);
        this.set(row, rowData);
    }

    @Override
    public void set(String rowLabel, String columnLabel, double value) {
        if (this.columnLabelBindings == null || this.rowLabelBindings == null) {
            throw new UnboundLabelException();
        }
        Integer row = this.rowLabelBindings.get(rowLabel);
        Integer col = this.columnLabelBindings.get(columnLabel);
        if (row == null || col == null) {
            throw new UnboundLabelException();
        }
        this.set(row, (int)col, value);
    }

    @Override
    public void set(String rowLabel, String columnLabel, int row, int column, double value) {
        if (this.rowLabelBindings == null) {
            this.rowLabelBindings = new HashMap<String, Integer>();
        }
        this.rowLabelBindings.put(rowLabel, row);
        if (this.columnLabelBindings == null) {
            this.columnLabelBindings = new HashMap<String, Integer>();
        }
        this.columnLabelBindings.put(columnLabel, column);
        this.set(row, column, value);
    }

    @Override
    public void setColumnLabelBindings(Map<String, Integer> bindings) {
        this.columnLabelBindings = bindings;
    }

    @Override
    public void setRowLabelBindings(Map<String, Integer> bindings) {
        this.rowLabelBindings = bindings;
    }

    @Override
    public int numRows() {
        return this.size()[0];
    }

    @Override
    public int numCols() {
        return this.size()[1];
    }

    @Override
    public String asFormatString() {
        return this.toString();
    }

    @Override
    public Matrix assign(double value) {
        int[] c = this.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.setQuick(row, col, value);
            }
        }
        return this;
    }

    @Override
    public Matrix assign(double[][] values) {
        int[] c = this.size();
        if (c[0] != values.length) {
            throw new CardinalityException(c[0], values.length);
        }
        for (int row = 0; row < c[0]; ++row) {
            if (c[1] == values[row].length) {
                for (int col = 0; col < c[1]; ++col) {
                    this.setQuick(row, col, values[row][col]);
                }
                continue;
            }
            throw new CardinalityException(c[1], values[row].length);
        }
        return this;
    }

    @Override
    public Matrix assign(Matrix other, DoubleDoubleFunction function) {
        int[] o;
        int[] c = this.size();
        if (c[0] != (o = other.size())[0]) {
            throw new CardinalityException(c[0], o[0]);
        }
        if (c[1] != o[1]) {
            throw new CardinalityException(c[1], o[1]);
        }
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.setQuick(row, col, function.apply(this.getQuick(row, col), other.getQuick(row, col)));
            }
        }
        return this;
    }

    @Override
    public Matrix assign(Matrix other) {
        int[] o;
        int[] c = this.size();
        if (c[0] != (o = other.size())[0]) {
            throw new CardinalityException(c[0], o[0]);
        }
        if (c[1] != o[1]) {
            throw new CardinalityException(c[1], o[1]);
        }
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.setQuick(row, col, other.getQuick(row, col));
            }
        }
        return this;
    }

    @Override
    public Matrix assign(DoubleFunction function) {
        int[] c = this.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                this.setQuick(row, col, function.apply(this.getQuick(row, col)));
            }
        }
        return this;
    }

    @Override
    public Vector aggregateRows(VectorFunction f) {
        DenseVector r = new DenseVector(this.numRows());
        int n = this.numRows();
        for (int row = 0; row < n; ++row) {
            r.set(row, f.apply(this.viewRow(row)));
        }
        return r;
    }

    @Override
    public Vector viewRow(int row) {
        return new MatrixVectorView(this, row, 0, 0, 1);
    }

    @Override
    public Vector viewColumn(int column) {
        return new MatrixVectorView(this, 0, column, 1, 0);
    }

    @Override
    public Vector aggregateColumns(VectorFunction f) {
        DenseVector r = new DenseVector(this.numCols());
        for (int col = 0; col < this.numCols(); ++col) {
            r.set(col, f.apply(this.viewColumn(col)));
        }
        return r;
    }

    @Override
    public double aggregate(final DoubleDoubleFunction combiner, final DoubleFunction mapper) {
        return this.aggregateRows(new VectorFunction(){

            @Override
            public double apply(Vector v) {
                return v.aggregate(combiner, mapper);
            }
        }).aggregate(combiner, Functions.IDENTITY);
    }

    @Override
    public double determinant() {
        int columnSize;
        int[] card = this.size();
        int rowSize = card[0];
        if (rowSize != (columnSize = card[1])) {
            throw new CardinalityException(rowSize, columnSize);
        }
        if (rowSize == 2) {
            return this.getQuick(0, 0) * this.getQuick(1, 1) - this.getQuick(0, 1) * this.getQuick(1, 0);
        }
        int sign = 1;
        double ret = 0.0;
        for (int i = 0; i < columnSize; ++i) {
            DenseMatrix minor = new DenseMatrix(rowSize - 1, columnSize - 1);
            for (int j = 1; j < rowSize; ++j) {
                boolean flag = false;
                for (int k = 0; k < columnSize; ++k) {
                    if (k == i) {
                        flag = true;
                        continue;
                    }
                    minor.set(j - 1, flag ? k - 1 : k, this.getQuick(j, k));
                }
            }
            ret += this.getQuick(0, i) * (double)sign * minor.determinant();
            sign *= -1;
        }
        return ret;
    }

    @Override
    public Matrix clone() {
        AbstractMatrix clone;
        try {
            clone = (AbstractMatrix)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException(cnse);
        }
        if (this.rowLabelBindings != null) {
            clone.rowLabelBindings = Maps.newHashMap(this.rowLabelBindings);
        }
        if (this.columnLabelBindings != null) {
            clone.columnLabelBindings = Maps.newHashMap(this.columnLabelBindings);
        }
        return clone;
    }

    @Override
    public Matrix divide(double x) {
        Matrix result = this.like();
        int[] c = this.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) / x);
            }
        }
        return result;
    }

    @Override
    public double get(int row, int column) {
        int[] c = this.size();
        if (row < 0 || row >= c[0]) {
            throw new IndexException(row, c[0]);
        }
        if (column < 0 || column >= c[1]) {
            throw new IndexException(column, c[1]);
        }
        return this.getQuick(row, column);
    }

    @Override
    public Matrix minus(Matrix other) {
        int[] o;
        int[] c = this.size();
        if (c[0] != (o = other.size())[0]) {
            throw new CardinalityException(c[0], o[0]);
        }
        if (c[1] != o[1]) {
            throw new CardinalityException(c[1], o[1]);
        }
        Matrix result = this.like();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) - other.getQuick(row, col));
            }
        }
        return result;
    }

    @Override
    public Matrix plus(double x) {
        Matrix result = this.like();
        int[] c = this.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) + x);
            }
        }
        return result;
    }

    @Override
    public Matrix plus(Matrix other) {
        int[] o;
        int[] c = this.size();
        if (c[0] != (o = other.size())[0]) {
            throw new CardinalityException(c[0], o[0]);
        }
        if (c[1] != o[1]) {
            throw new CardinalityException(c[1], o[1]);
        }
        Matrix result = this.like();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) + other.getQuick(row, col));
            }
        }
        return result;
    }

    @Override
    public void set(int row, int column, double value) {
        int[] c = this.size();
        if (row < 0 || row >= c[0]) {
            throw new IndexException(row, c[0]);
        }
        if (column < 0 || column >= c[1]) {
            throw new IndexException(column, c[1]);
        }
        this.setQuick(row, column, value);
    }

    @Override
    public void set(int row, double[] data) {
        int[] c = this.size();
        if (c[1] < data.length) {
            throw new CardinalityException(c[1], data.length);
        }
        if (row < 0 || row >= c[0]) {
            throw new IndexException(row, c[0]);
        }
        for (int i = 0; i < c[1]; ++i) {
            this.setQuick(row, i, data[i]);
        }
    }

    @Override
    public Matrix times(double x) {
        Matrix result = this.like();
        int[] c = this.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) * x);
            }
        }
        return result;
    }

    @Override
    public Matrix times(Matrix other) {
        int[] o;
        int[] c = this.size();
        if (c[1] != (o = other.size())[0]) {
            throw new CardinalityException(c[1], o[0]);
        }
        Matrix result = this.like(c[0], o[1]);
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < o[1]; ++col) {
                double sum = 0.0;
                for (int k = 0; k < c[1]; ++k) {
                    sum += this.getQuick(row, k) * other.getQuick(k, col);
                }
                result.setQuick(row, col, sum);
            }
        }
        return result;
    }

    @Override
    public Vector times(Vector v) {
        int[] c = this.size();
        if (c[1] != v.size()) {
            throw new CardinalityException(c[1], v.size());
        }
        DenseVector w = new DenseVector(c[0]);
        for (int i = 0; i < c[0]; ++i) {
            w.setQuick(i, v.dot(this.getRow(i)));
        }
        return w;
    }

    @Override
    public Vector timesSquared(Vector v) {
        int[] c = this.size();
        if (c[1] != v.size()) {
            throw new CardinalityException(c[1], v.size());
        }
        DenseVector w = new DenseVector(c[1]);
        for (int i = 0; i < c[0]; ++i) {
            Vector xi = this.getRow(i);
            double d = xi.dot(v);
            if (d == 0.0) continue;
            w.assign(xi, new PlusMult(d));
        }
        return w;
    }

    @Override
    public Matrix transpose() {
        int[] card = this.size();
        Matrix result = this.like(card[1], card[0]);
        for (int row = 0; row < card[0]; ++row) {
            for (int col = 0; col < card[1]; ++col) {
                result.setQuick(col, row, this.getQuick(row, col));
            }
        }
        return result;
    }

    @Override
    public Matrix viewPart(int rowOffset, int rowsRequested, int columnOffset, int columnsRequested) {
        return this.viewPart(new int[]{rowOffset, columnOffset}, new int[]{rowsRequested, columnsRequested});
    }

    @Override
    public double zSum() {
        double result = 0.0;
        int[] c = this.size();
        for (int row = 0; row < c[0]; ++row) {
            for (int col = 0; col < c[1]; ++col) {
                result += this.getQuick(row, col);
            }
        }
        return result;
    }

    protected class TransposeViewVector
    extends AbstractVector {
        private final Matrix matrix;
        private final int transposeOffset;
        private final int numCols;
        private final boolean rowToColumn;

        protected TransposeViewVector(Matrix m, int offset) {
            this(m, offset, true);
        }

        protected TransposeViewVector(Matrix m, int offset, boolean rowToColumn) {
            super(rowToColumn ? m.numRows() : m.numCols());
            this.matrix = m;
            this.transposeOffset = offset;
            this.rowToColumn = rowToColumn;
            this.numCols = rowToColumn ? m.numCols() : m.numRows();
        }

        @Override
        public Vector clone() {
            DenseVector v = new DenseVector(this.size());
            this.addTo(v);
            return v;
        }

        @Override
        public boolean isDense() {
            return true;
        }

        @Override
        public boolean isSequentialAccess() {
            return true;
        }

        @Override
        protected Matrix matrixLike(int rows, int columns) {
            return this.matrix.like(rows, columns);
        }

        @Override
        public Iterator<Vector.Element> iterator() {
            return new Iterator<Vector.Element>(){
                private int i;

                @Override
                public boolean hasNext() {
                    return this.i < TransposeViewVector.this.size();
                }

                @Override
                public Vector.Element next() {
                    if (this.i >= TransposeViewVector.this.size()) {
                        throw new NoSuchElementException();
                    }
                    return TransposeViewVector.this.getElement(this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Element removal not supported");
                }
            };
        }

        @Override
        public Iterator<Vector.Element> iterateNonZero() {
            return this.iterator();
        }

        @Override
        public Vector.Element getElement(final int i) {
            return new Vector.Element(){

                @Override
                public double get() {
                    return TransposeViewVector.this.getQuick(i);
                }

                @Override
                public int index() {
                    return i;
                }

                @Override
                public void set(double value) {
                    TransposeViewVector.this.setQuick(i, value);
                }
            };
        }

        @Override
        public double getQuick(int index) {
            Vector v = this.rowToColumn ? this.matrix.getRow(index) : this.matrix.getColumn(index);
            return v == null ? 0.0 : v.getQuick(this.transposeOffset);
        }

        @Override
        public void setQuick(int index, double value) {
            Vector v;
            Vector vector = v = this.rowToColumn ? this.matrix.getRow(index) : this.matrix.getColumn(index);
            if (v == null) {
                v = this.newVector(this.numCols);
                this.matrix.assignRow(index, v);
            }
            v.setQuick(this.transposeOffset, value);
        }

        protected Vector newVector(int cardinality) {
            return new DenseVector(cardinality);
        }

        @Override
        public Vector like() {
            return new DenseVector(this.size());
        }

        public Vector like(int cardinality) {
            return new DenseVector(cardinality);
        }

        @Override
        public int getNumNondefaultElements() {
            return this.size();
        }
    }
}

