/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixView;
import org.apache.mahout.math.Vector;

public class VectorList
extends AbstractMatrix {
    private final int columns;
    private final List<Vector> data = Lists.newArrayList();

    public VectorList(int columns) {
        this.columns = columns;
        this.cardinality[1] = columns;
    }

    public VectorList(int rows, int columns) {
        this(columns);
        this.extendTo(rows);
    }

    @Override
    public int columnSize() {
        return this.columns;
    }

    @Override
    public int rowSize() {
        return this.data.size();
    }

    @Override
    public int[] size() {
        this.cardinality[0] = this.data.size();
        return this.cardinality;
    }

    @Override
    public Matrix assignColumn(int column, Vector other) {
        if (other.size() != this.rowSize()) {
            throw new CardinalityException(this.rowSize(), other.size());
        }
        int i = 0;
        for (Vector row : this.data) {
            if (row == null) {
                throw new NullPointerException("Can't insert value into null row ... is matrix row sparse?");
            }
            row.set(column, other.get(i));
            ++i;
        }
        return this;
    }

    @Override
    public Matrix assignRow(int row, Vector other) {
        if (other.size() != this.columns) {
            throw new CardinalityException(this.columns, other.size());
        }
        this.extendTo(row + 1);
        this.data.set(row, other);
        return this;
    }

    @Override
    public Vector getColumn(final int column) {
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        return new AbstractVector(this.rowSize()){

            @Override
            protected Matrix matrixLike(int rows, int columns) {
                throw new UnsupportedOperationException("Can't get a matrix like a VectorList");
            }

            @Override
            public boolean isDense() {
                return true;
            }

            @Override
            public boolean isSequentialAccess() {
                return true;
            }

            @Override
            public Iterator<Vector.Element> iterator() {
                return new AbstractIterator<Vector.Element>(){
                    int i = 0;

                    protected Vector.Element computeNext() {
                        if (this.i >= VectorList.this.data.size()) {
                            return (Vector.Element)this.endOfData();
                        }
                        return new Vector.Element(){
                            final int row;
                            {
                                this.row = i++;
                            }

                            @Override
                            public double get() {
                                return VectorList.this.get(this.row, column);
                            }

                            @Override
                            public int index() {
                                return this.row;
                            }

                            @Override
                            public void set(double value) {
                                VectorList.this.setQuick(this.row, column, value);
                            }
                        };
                    }
                };
            }

            @Override
            public Iterator<Vector.Element> iterateNonZero() {
                return this.iterator();
            }

            @Override
            public double getQuick(int index) {
                return VectorList.this.getQuick(index, column);
            }

            @Override
            public Vector like() {
                return new DenseVector(VectorList.this.rowSize());
            }

            @Override
            public void setQuick(int index, double value) {
                VectorList.this.setQuick(index, column, value);
            }

            @Override
            public int getNumNondefaultElements() {
                return VectorList.this.data.size();
            }
        };
    }

    @Override
    public Vector getRow(int row) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        return this.data.get(row);
    }

    @Override
    public double getQuick(int row, int column) {
        return this.data.get(row).getQuick(column);
    }

    @Override
    public Matrix like() {
        VectorList r = new VectorList(this.columns);
        for (Vector vector : this.data) {
            r.adjoinRow(vector.like());
        }
        return r;
    }

    @Override
    public Matrix like(int rows, int columns) {
        VectorList r = new VectorList(rows, columns);
        for (int i = 0; i < rows; ++i) {
            r.data.set(i, new DenseVector(columns));
        }
        return r;
    }

    @Override
    public void setQuick(int row, int column, double value) {
        this.data.get(row).setQuick(column, value);
    }

    @Override
    public int[] getNumNondefaultElements() {
        return new int[]{this.data.size(), this.columns};
    }

    @Override
    public Matrix viewPart(int[] offset, int[] size) {
        this.cardinality[0] = this.data.size();
        return new MatrixView(this, offset, size);
    }

    private void extendTo(int newLimit) {
        while (this.data.size() < newLimit) {
            this.data.add(null);
        }
    }

    public void adjoinRow(Vector vector) {
        Preconditions.checkArgument((vector.size() == this.columns ? 1 : 0) != 0);
        this.data.add(vector);
    }

    public void adjoinRow(Matrix other) {
        Preconditions.checkArgument((other.columnSize() == this.columns ? 1 : 0) != 0);
        for (int row = 0; row < other.rowSize(); ++row) {
            this.adjoinRow(other.getRow(row));
        }
    }
}

