/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.als;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.Vector;

public class AlternateLeastSquaresSolver {
    public Vector solve(List<Vector> featureVectors, Vector ratingVector, double lambda, int numFeatures) {
        Preconditions.checkNotNull(featureVectors, (Object)"Feature vectors cannot be null");
        Preconditions.checkArgument((!featureVectors.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)ratingVector, (Object)"Rating vector cannot be null");
        Preconditions.checkArgument((featureVectors.size() == ratingVector.getNumNondefaultElements() ? 1 : 0) != 0);
        int nui = ratingVector.getNumNondefaultElements();
        Matrix MiIi = this.createMiIi(featureVectors, numFeatures);
        Matrix RiIiMaybeTransposed = this.createRiIiMaybeTransposed(ratingVector);
        Matrix Ai = this.addLambdaTimesNuiTimesE(MiIi.times(MiIi.transpose()), lambda, nui);
        Matrix Vi = MiIi.times(RiIiMaybeTransposed);
        return this.solve(Ai, Vi);
    }

    Vector solve(Matrix Ai, Matrix Vi) {
        return new QRDecomposition(Ai).solve(Vi).getColumn(0);
    }

    protected Matrix addLambdaTimesNuiTimesE(Matrix matrix, double lambda, int nui) {
        Preconditions.checkArgument((matrix.numCols() == matrix.numRows() ? 1 : 0) != 0);
        double lambdaTimesNui = lambda * (double)nui;
        for (int n = 0; n < matrix.numCols(); ++n) {
            matrix.setQuick(n, n, matrix.getQuick(n, n) + lambdaTimesNui);
        }
        return matrix;
    }

    protected Matrix createMiIi(List<Vector> featureVectors, int numFeatures) {
        DenseMatrix MiIi = new DenseMatrix(numFeatures, featureVectors.size());
        for (int n = 0; n < featureVectors.size(); ++n) {
            Vector featureVector = featureVectors.get(n);
            for (int m = 0; m < numFeatures; ++m) {
                MiIi.setQuick(m, n, featureVector.get(m));
            }
        }
        return MiIi;
    }

    protected Matrix createRiIiMaybeTransposed(Vector ratingVector) {
        Preconditions.checkArgument((boolean)ratingVector.isSequentialAccess());
        DenseMatrix RiIiMaybeTransposed = new DenseMatrix(ratingVector.getNumNondefaultElements(), 1);
        Iterator<Vector.Element> ratingsIterator = ratingVector.iterateNonZero();
        int index = 0;
        while (ratingsIterator.hasNext()) {
            Vector.Element elem = ratingsIterator.next();
            RiIiMaybeTransposed.setQuick(index++, 0, elem.get());
        }
        return RiIiMaybeTransposed;
    }
}

