/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decomposer.lanczos;

import java.util.HashMap;
import java.util.Map;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;

public class LanczosState {
    protected Matrix diagonalMatrix;
    protected VectorIterable corpus;
    protected double scaleFactor;
    protected int iterationNumber;
    protected int desiredRank;
    protected Map<Integer, Vector> basis;
    protected Map<Integer, Double> singularValues;
    protected Map<Integer, Vector> singularVectors;

    public LanczosState(VectorIterable corpus, int numCols, int desiredRank, Vector initialVector) {
        this.corpus = corpus;
        this.desiredRank = desiredRank;
        this.intitializeBasisAndSingularVectors(numCols, desiredRank);
        this.setBasisVector(0, initialVector);
        this.scaleFactor = 0.0;
        this.diagonalMatrix = new DenseMatrix(desiredRank, desiredRank);
        this.singularValues = new HashMap<Integer, Double>();
        this.iterationNumber = 1;
    }

    protected void intitializeBasisAndSingularVectors(int numCols, int rank) {
        this.basis = new HashMap<Integer, Vector>();
        this.singularVectors = new HashMap<Integer, Vector>();
    }

    public Matrix getDiagonalMatrix() {
        return this.diagonalMatrix;
    }

    public int getIterationNumber() {
        return this.iterationNumber;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public VectorIterable getCorpus() {
        return this.corpus;
    }

    public Vector getRightSingularVector(int i) {
        return this.singularVectors.get(i);
    }

    public Double getSingularValue(int i) {
        return this.singularValues.get(i);
    }

    public Vector getBasisVector(int i) {
        return this.basis.get(i);
    }

    public void setBasisVector(int i, Vector basisVector) {
        this.basis.put(i, basisVector);
    }

    public void setScaleFactor(double scale) {
        this.scaleFactor = scale;
    }

    public void setIterationNumber(int i) {
        this.iterationNumber = i;
    }

    public void setRightSingularVector(int i, Vector vector) {
        this.singularVectors.put(i, vector);
    }

    public void setSingularValue(int i, double value) {
        this.singularValues.put(i, value);
    }
}

