/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import org.apache.mahout.math.list.DoubleArrayList;

public class OnlineSummarizer {
    private boolean sorted = true;
    private DoubleArrayList starter = new DoubleArrayList(100);
    private final double[] q = new double[5];
    private double mean;
    private double variance;
    private int n;

    public void add(double sample) {
        this.sorted = false;
        ++this.n;
        double oldMean = this.mean;
        this.mean += (sample - this.mean) / (double)this.n;
        double diff = (sample - this.mean) * (sample - oldMean);
        this.variance += (diff - this.variance) / (double)this.n;
        if (this.n < 100) {
            this.starter.add(sample);
        } else if (this.n == 100 && this.starter != null) {
            this.starter.add(sample);
            for (int i = 0; i <= 4; ++i) {
                this.q[i] = this.getQuartile(i);
            }
            this.starter = null;
        } else {
            this.q[0] = Math.min(sample, this.q[0]);
            this.q[4] = Math.max(sample, this.q[4]);
            double rate = 2.0 * (this.q[3] - this.q[1]) / (double)this.n;
            this.q[1] = this.q[1] + (Math.signum(sample - this.q[1]) - 0.5) * rate;
            this.q[2] = this.q[2] + Math.signum(sample - this.q[2]) * rate;
            this.q[3] = this.q[3] + (Math.signum(sample - this.q[3]) + 0.5) * rate;
            if (this.q[1] < this.q[0]) {
                this.q[1] = this.q[0];
            }
            if (this.q[3] > this.q[4]) {
                this.q[3] = this.q[4];
            }
        }
    }

    public int getCount() {
        return this.n;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSD() {
        return Math.sqrt(this.variance);
    }

    public double getMin() {
        return this.getQuartile(0);
    }

    private void sort() {
        if (!this.sorted && this.starter != null) {
            this.starter.sortFromTo(0, 99);
            this.sorted = true;
        }
    }

    public double getMax() {
        return this.getQuartile(4);
    }

    public double getQuartile(int i) {
        if (this.n > 100 || this.starter == null) {
            return this.q[i];
        }
        this.sort();
        switch (i) {
            case 0: {
                if (this.n == 0) {
                    throw new IllegalArgumentException("Must have at least one sample to estimate minimum value");
                }
                return this.starter.get(0);
            }
            case 1: 
            case 2: 
            case 3: {
                if (this.n >= 2) {
                    double x = (double)(i * (this.n - 1)) / 4.0;
                    int k = (int)Math.floor(x);
                    double u = x - (double)k;
                    return this.starter.get(k) * (1.0 - u) + this.starter.get(k + 1) * u;
                }
                throw new IllegalArgumentException("Must have at least two samples to estimate quartiles");
            }
            case 4: {
                if (this.n == 0) {
                    throw new IllegalArgumentException("Must have at least one sample to estimate maximum value");
                }
                return this.starter.get(this.starter.size() - 1);
            }
        }
        throw new IllegalArgumentException("Quartile number must be in the range [0..4] not " + i);
    }

    public double getMedian() {
        return this.getQuartile(2);
    }
}

