/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.ByteFloatProcedure;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.function.FloatFunction;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.list.ByteArrayList;
import org.apache.mahout.math.list.FloatArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractByteFloatMap
extends AbstractSet {
    public boolean containsKey(final byte key) {
        return !this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final float value) {
        return !this.forEachPair(new ByteFloatProcedure(){

            @Override
            public boolean apply(byte iterKey, float iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractByteFloatMap copy() {
        return (AbstractByteFloatMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractByteFloatMap)) {
            return false;
        }
        final AbstractByteFloatMap other = (AbstractByteFloatMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ByteFloatProcedure(){

            @Override
            public boolean apply(byte key, float value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ByteFloatProcedure(){

            @Override
            public boolean apply(byte key, float value) {
                return AbstractByteFloatMap.this.containsKey(key) && AbstractByteFloatMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ByteProcedure var1);

    public boolean forEachPair(final ByteFloatProcedure procedure) {
        return this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                return procedure.apply(key, AbstractByteFloatMap.this.get(key));
            }
        });
    }

    public abstract float get(byte var1);

    public ByteArrayList keys() {
        ByteArrayList list = new ByteArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ByteArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ByteArrayList keyList) {
        this.pairsSortedByValue(keyList, new FloatArrayList(this.size()));
    }

    public void pairsMatching(final ByteFloatProcedure condition, final ByteArrayList keyList, final FloatArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ByteFloatProcedure(){

            @Override
            public boolean apply(byte key, float value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ByteArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ByteArrayList keyList, FloatArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final byte[] k = keyList.elements();
        final float[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                float t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                byte t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(byte var1, float var2);

    public abstract boolean removeKey(byte var1);

    public String toString() {
        ByteArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ByteArrayList theKeys = new ByteArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            byte key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public FloatArrayList values() {
        FloatArrayList list = new FloatArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final FloatArrayList list) {
        list.clear();
        this.forEachKey(new ByteProcedure(){

            @Override
            public boolean apply(byte key) {
                list.add(AbstractByteFloatMap.this.get(key));
                return true;
            }
        });
    }

    public void assign(final FloatFunction function) {
        this.copy().forEachPair(new ByteFloatProcedure(){

            @Override
            public boolean apply(byte key, float value) {
                AbstractByteFloatMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractByteFloatMap other) {
        this.clear();
        other.forEachPair(new ByteFloatProcedure(){

            @Override
            public boolean apply(byte key, float value) {
                AbstractByteFloatMap.this.put(key, value);
                return true;
            }
        });
    }

    public float adjustOrPutValue(byte key, float newValue, float incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = this.get(key) + incrValue;
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

