/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.map;

import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.Swapper;
import org.apache.mahout.math.function.IntComparator;
import org.apache.mahout.math.function.ShortCharProcedure;
import org.apache.mahout.math.function.ShortProcedure;
import org.apache.mahout.math.list.CharArrayList;
import org.apache.mahout.math.list.ShortArrayList;
import org.apache.mahout.math.set.AbstractSet;

public abstract class AbstractShortCharMap
extends AbstractSet {
    public boolean containsKey(final short key) {
        return !this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final char value) {
        return !this.forEachPair(new ShortCharProcedure(){

            @Override
            public boolean apply(short iterKey, char iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractShortCharMap copy() {
        return (AbstractShortCharMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractShortCharMap)) {
            return false;
        }
        final AbstractShortCharMap other = (AbstractShortCharMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new ShortCharProcedure(){

            @Override
            public boolean apply(short key, char value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new ShortCharProcedure(){

            @Override
            public boolean apply(short key, char value) {
                return AbstractShortCharMap.this.containsKey(key) && AbstractShortCharMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(ShortProcedure var1);

    public boolean forEachPair(final ShortCharProcedure procedure) {
        return this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                return procedure.apply(key, AbstractShortCharMap.this.get(key));
            }
        });
    }

    public abstract char get(short var1);

    public ShortArrayList keys() {
        ShortArrayList list = new ShortArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final ShortArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(ShortArrayList keyList) {
        this.pairsSortedByValue(keyList, new CharArrayList(this.size()));
    }

    public void pairsMatching(final ShortCharProcedure condition, final ShortArrayList keyList, final CharArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new ShortCharProcedure(){

            @Override
            public boolean apply(short key, char value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(ShortArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(ShortArrayList keyList, CharArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final short[] k = keyList.elements();
        final char[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                char t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                short t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        Sorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(short var1, char var2);

    public abstract boolean removeKey(short var1);

    public String toString() {
        ShortArrayList theKeys = this.keys();
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public String toStringByValue() {
        ShortArrayList theKeys = new ShortArrayList();
        this.keysSortedByValue(theKeys);
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            short key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append(']');
        return buf.toString();
    }

    public CharArrayList values() {
        CharArrayList list = new CharArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final CharArrayList list) {
        list.clear();
        this.forEachKey(new ShortProcedure(){

            @Override
            public boolean apply(short key) {
                list.add(AbstractShortCharMap.this.get(key));
                return true;
            }
        });
    }

    public char adjustOrPutValue(short key, char newValue, char incrValue) {
        boolean present = this.containsKey(key);
        if (present) {
            newValue = (char)(this.get(key) + incrValue);
            this.put(key, newValue);
        } else {
            this.put(key, newValue);
        }
        return newValue;
    }
}

