/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.mahout.math.AbstractVector;
import org.apache.mahout.math.CardinalityException;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.IndexException;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.MatrixVectorView;
import org.apache.mahout.math.OrderedIntDoubleMapping;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.DoubleDoubleFunction;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.PlusMult;
import org.apache.mahout.math.function.VectorFunction;

public abstract class AbstractMatrix
implements Matrix {
    protected Map<String, Integer> columnLabelBindings;
    protected Map<String, Integer> rowLabelBindings;
    protected int rows;
    protected int columns;
    public static final int COL = 1;
    public static final int ROW = 0;

    protected AbstractMatrix(int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
    }

    @Override
    public int columnSize() {
        return this.columns;
    }

    @Override
    public int rowSize() {
        return this.rows;
    }

    @Override
    public Iterator<MatrixSlice> iterator() {
        return this.iterateAll();
    }

    @Override
    public Iterator<MatrixSlice> iterateAll() {
        return new AbstractIterator<MatrixSlice>(){
            private int slice;

            protected MatrixSlice computeNext() {
                if (this.slice >= AbstractMatrix.this.numSlices()) {
                    return (MatrixSlice)this.endOfData();
                }
                int i = this.slice++;
                return new MatrixSlice(AbstractMatrix.this.viewRow(i), i);
            }
        };
    }

    @Override
    public int numSlices() {
        return this.numRows();
    }

    @Override
    public double get(String rowLabel, String columnLabel) {
        if (this.columnLabelBindings == null || this.rowLabelBindings == null) {
            throw new IllegalStateException("Unbound label");
        }
        Integer row = this.rowLabelBindings.get(rowLabel);
        Integer col = this.columnLabelBindings.get(columnLabel);
        if (row == null || col == null) {
            throw new IllegalStateException("Unbound label");
        }
        return this.get(row, col);
    }

    @Override
    public Map<String, Integer> getColumnLabelBindings() {
        return this.columnLabelBindings;
    }

    @Override
    public Map<String, Integer> getRowLabelBindings() {
        return this.rowLabelBindings;
    }

    @Override
    public void set(String rowLabel, double[] rowData) {
        if (this.columnLabelBindings == null) {
            throw new IllegalStateException("Unbound label");
        }
        Integer row = this.rowLabelBindings.get(rowLabel);
        if (row == null) {
            throw new IllegalStateException("Unbound label");
        }
        this.set(row, rowData);
    }

    @Override
    public void set(String rowLabel, int row, double[] rowData) {
        if (this.rowLabelBindings == null) {
            this.rowLabelBindings = Maps.newHashMap();
        }
        this.rowLabelBindings.put(rowLabel, row);
        this.set(row, rowData);
    }

    @Override
    public void set(String rowLabel, String columnLabel, double value) {
        if (this.columnLabelBindings == null || this.rowLabelBindings == null) {
            throw new IllegalStateException("Unbound label");
        }
        Integer row = this.rowLabelBindings.get(rowLabel);
        Integer col = this.columnLabelBindings.get(columnLabel);
        if (row == null || col == null) {
            throw new IllegalStateException("Unbound label");
        }
        this.set(row, (int)col, value);
    }

    @Override
    public void set(String rowLabel, String columnLabel, int row, int column, double value) {
        if (this.rowLabelBindings == null) {
            this.rowLabelBindings = Maps.newHashMap();
        }
        this.rowLabelBindings.put(rowLabel, row);
        if (this.columnLabelBindings == null) {
            this.columnLabelBindings = Maps.newHashMap();
        }
        this.columnLabelBindings.put(columnLabel, column);
        this.set(row, column, value);
    }

    @Override
    public void setColumnLabelBindings(Map<String, Integer> bindings) {
        this.columnLabelBindings = bindings;
    }

    @Override
    public void setRowLabelBindings(Map<String, Integer> bindings) {
        this.rowLabelBindings = bindings;
    }

    @Override
    public int numRows() {
        return this.rowSize();
    }

    @Override
    public int numCols() {
        return this.columnSize();
    }

    @Override
    public String asFormatString() {
        return this.toString();
    }

    @Override
    public Matrix assign(double value) {
        int rows = this.rowSize();
        int columns = this.columnSize();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.setQuick(row, col, value);
            }
        }
        return this;
    }

    @Override
    public Matrix assign(double[][] values) {
        int rows = this.rowSize();
        if (rows != values.length) {
            throw new CardinalityException(rows, values.length);
        }
        int columns = this.columnSize();
        for (int row = 0; row < rows; ++row) {
            if (columns == values[row].length) {
                for (int col = 0; col < columns; ++col) {
                    this.setQuick(row, col, values[row][col]);
                }
                continue;
            }
            throw new CardinalityException(columns, values[row].length);
        }
        return this;
    }

    @Override
    public Matrix assign(Matrix other, DoubleDoubleFunction function) {
        int rows = this.rowSize();
        if (rows != other.rowSize()) {
            throw new CardinalityException(rows, other.rowSize());
        }
        int columns = this.columnSize();
        if (columns != other.columnSize()) {
            throw new CardinalityException(columns, other.columnSize());
        }
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.setQuick(row, col, function.apply(this.getQuick(row, col), other.getQuick(row, col)));
            }
        }
        return this;
    }

    @Override
    public Matrix assign(Matrix other) {
        int rows = this.rowSize();
        if (rows != other.rowSize()) {
            throw new CardinalityException(rows, other.rowSize());
        }
        int columns = this.columnSize();
        if (columns != other.columnSize()) {
            throw new CardinalityException(columns, other.columnSize());
        }
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.setQuick(row, col, other.getQuick(row, col));
            }
        }
        return this;
    }

    @Override
    public Matrix assign(DoubleFunction function) {
        int rows = this.rowSize();
        int columns = this.columnSize();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                this.setQuick(row, col, function.apply(this.getQuick(row, col)));
            }
        }
        return this;
    }

    @Override
    public Vector aggregateRows(VectorFunction f) {
        DenseVector r = new DenseVector(this.numRows());
        int n = this.numRows();
        for (int row = 0; row < n; ++row) {
            r.set(row, f.apply(this.viewRow(row)));
        }
        return r;
    }

    @Override
    public Vector viewRow(int row) {
        return new MatrixVectorView(this, row, 0, 0, 1);
    }

    @Override
    public Vector viewColumn(int column) {
        return new MatrixVectorView(this, 0, column, 1, 0);
    }

    @Override
    public Vector viewDiagonal() {
        return new MatrixVectorView(this, 0, 0, 1, 1);
    }

    @Override
    public double aggregate(final DoubleDoubleFunction combiner, final DoubleFunction mapper) {
        return this.aggregateRows(new VectorFunction(){

            @Override
            public double apply(Vector v) {
                return v.aggregate(combiner, mapper);
            }
        }).aggregate(combiner, Functions.IDENTITY);
    }

    @Override
    public Vector aggregateColumns(VectorFunction f) {
        DenseVector r = new DenseVector(this.numCols());
        for (int col = 0; col < this.numCols(); ++col) {
            r.set(col, f.apply(this.viewColumn(col)));
        }
        return r;
    }

    @Override
    public double determinant() {
        int columns;
        int rows = this.rowSize();
        if (rows != (columns = this.columnSize())) {
            throw new CardinalityException(rows, columns);
        }
        if (rows == 2) {
            return this.getQuick(0, 0) * this.getQuick(1, 1) - this.getQuick(0, 1) * this.getQuick(1, 0);
        }
        int sign = 1;
        double ret = 0.0;
        for (int i = 0; i < columns; ++i) {
            DenseMatrix minor = new DenseMatrix(rows - 1, columns - 1);
            for (int j = 1; j < rows; ++j) {
                boolean flag = false;
                for (int k = 0; k < columns; ++k) {
                    if (k == i) {
                        flag = true;
                        continue;
                    }
                    minor.set(j - 1, flag ? k - 1 : k, this.getQuick(j, k));
                }
            }
            ret += this.getQuick(0, i) * (double)sign * minor.determinant();
            sign *= -1;
        }
        return ret;
    }

    @Override
    public Matrix clone() {
        AbstractMatrix clone;
        try {
            clone = (AbstractMatrix)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new IllegalStateException(cnse);
        }
        if (this.rowLabelBindings != null) {
            clone.rowLabelBindings = Maps.newHashMap(this.rowLabelBindings);
        }
        if (this.columnLabelBindings != null) {
            clone.columnLabelBindings = Maps.newHashMap(this.columnLabelBindings);
        }
        return clone;
    }

    @Override
    public Matrix divide(double x) {
        Matrix result = this.like();
        for (int row = 0; row < this.rowSize(); ++row) {
            for (int col = 0; col < this.columnSize(); ++col) {
                result.setQuick(row, col, this.getQuick(row, col) / x);
            }
        }
        return result;
    }

    @Override
    public double get(int row, int column) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        return this.getQuick(row, column);
    }

    @Override
    public Matrix minus(Matrix other) {
        int rows = this.rowSize();
        if (rows != other.rowSize()) {
            throw new CardinalityException(rows, other.rowSize());
        }
        int columns = this.columnSize();
        if (columns != other.columnSize()) {
            throw new CardinalityException(columns, other.columnSize());
        }
        Matrix result = this.like();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) - other.getQuick(row, col));
            }
        }
        return result;
    }

    @Override
    public Matrix plus(double x) {
        Matrix result = this.like();
        int rows = this.rowSize();
        int columns = this.columnSize();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) + x);
            }
        }
        return result;
    }

    @Override
    public Matrix plus(Matrix other) {
        int rows = this.rowSize();
        if (rows != other.rowSize()) {
            throw new CardinalityException(rows, other.rowSize());
        }
        int columns = this.columnSize();
        if (columns != other.columnSize()) {
            throw new CardinalityException(columns, other.columnSize());
        }
        Matrix result = this.like();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) + other.getQuick(row, col));
            }
        }
        return result;
    }

    @Override
    public void set(int row, int column, double value) {
        if (row < 0 || row >= this.rowSize()) {
            throw new IndexException(row, this.rowSize());
        }
        if (column < 0 || column >= this.columnSize()) {
            throw new IndexException(column, this.columnSize());
        }
        this.setQuick(row, column, value);
    }

    @Override
    public void set(int row, double[] data) {
        int columns = this.columnSize();
        if (columns < data.length) {
            throw new CardinalityException(columns, data.length);
        }
        int rows = this.rowSize();
        if (row < 0 || row >= rows) {
            throw new IndexException(row, this.rowSize());
        }
        for (int i = 0; i < columns; ++i) {
            this.setQuick(row, i, data[i]);
        }
    }

    @Override
    public Matrix times(double x) {
        Matrix result = this.like();
        int rows = this.rowSize();
        int columns = this.columnSize();
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                result.setQuick(row, col, this.getQuick(row, col) * x);
            }
        }
        return result;
    }

    @Override
    public Matrix times(Matrix other) {
        int columns = this.columnSize();
        if (columns != other.rowSize()) {
            throw new CardinalityException(columns, other.rowSize());
        }
        int rows = this.rowSize();
        int otherColumns = other.columnSize();
        Matrix result = this.like(rows, otherColumns);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < otherColumns; ++col) {
                double sum = 0.0;
                for (int k = 0; k < columns; ++k) {
                    sum += this.getQuick(row, k) * other.getQuick(k, col);
                }
                result.setQuick(row, col, sum);
            }
        }
        return result;
    }

    @Override
    public Vector times(Vector v) {
        int columns = this.columnSize();
        if (columns != v.size()) {
            throw new CardinalityException(columns, v.size());
        }
        int rows = this.rowSize();
        DenseVector w = new DenseVector(rows);
        for (int row = 0; row < rows; ++row) {
            w.setQuick(row, v.dot(this.viewRow(row)));
        }
        return w;
    }

    @Override
    public Vector timesSquared(Vector v) {
        int columns = this.columnSize();
        if (columns != v.size()) {
            throw new CardinalityException(columns, v.size());
        }
        int rows = this.rowSize();
        DenseVector w = new DenseVector(columns);
        for (int i = 0; i < rows; ++i) {
            Vector xi = this.viewRow(i);
            double d = xi.dot(v);
            if (d == 0.0) continue;
            w.assign(xi, new PlusMult(d));
        }
        return w;
    }

    @Override
    public Matrix transpose() {
        int rows = this.rowSize();
        int columns = this.columnSize();
        Matrix result = this.like(columns, rows);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < columns; ++col) {
                result.setQuick(col, row, this.getQuick(row, col));
            }
        }
        return result;
    }

    @Override
    public Matrix viewPart(int rowOffset, int rowsRequested, int columnOffset, int columnsRequested) {
        return this.viewPart(new int[]{rowOffset, columnOffset}, new int[]{rowsRequested, columnsRequested});
    }

    @Override
    public double zSum() {
        double result = 0.0;
        for (int row = 0; row < this.rowSize(); ++row) {
            for (int col = 0; col < this.columnSize(); ++col) {
                result += this.getQuick(row, col);
            }
        }
        return result;
    }

    @Override
    public int[] getNumNondefaultElements() {
        return new int[]{this.rowSize(), this.columnSize()};
    }

    public String toString() {
        StringBuilder s = new StringBuilder("{\n");
        for (MatrixSlice next : this) {
            s.append("  ").append(next.index()).append("  =>\t").append(next.vector()).append('\n');
        }
        s.append("}");
        return s.toString();
    }

    protected static class TransposeViewVector
    extends AbstractVector {
        private final Matrix matrix;
        private final int transposeOffset;
        private final int numCols;
        private final boolean rowToColumn;

        protected TransposeViewVector(Matrix m, int offset) {
            this(m, offset, true);
        }

        protected TransposeViewVector(Matrix m, int offset, boolean rowToColumn) {
            super(rowToColumn ? m.numRows() : m.numCols());
            this.matrix = m;
            this.transposeOffset = offset;
            this.rowToColumn = rowToColumn;
            this.numCols = rowToColumn ? m.numCols() : m.numRows();
        }

        @Override
        public Vector clone() {
            DenseVector v = new DenseVector(this.size());
            v.assign(this, Functions.PLUS);
            return v;
        }

        @Override
        public boolean isDense() {
            return true;
        }

        @Override
        public boolean isSequentialAccess() {
            return true;
        }

        @Override
        protected Matrix matrixLike(int rows, int columns) {
            return this.matrix.like(rows, columns);
        }

        @Override
        public Iterator<Vector.Element> iterator() {
            return new AbstractIterator<Vector.Element>(){
                private int i;

                protected Vector.Element computeNext() {
                    if (this.i >= TransposeViewVector.this.size()) {
                        return (Vector.Element)this.endOfData();
                    }
                    return TransposeViewVector.this.getElement(this.i++);
                }
            };
        }

        @Override
        public Iterator<Vector.Element> iterateNonZero() {
            return this.iterator();
        }

        @Override
        public Vector.Element getElement(final int i) {
            return new Vector.Element(){

                @Override
                public double get() {
                    return TransposeViewVector.this.getQuick(i);
                }

                @Override
                public int index() {
                    return i;
                }

                @Override
                public void set(double value) {
                    TransposeViewVector.this.setQuick(i, value);
                }
            };
        }

        @Override
        public void mergeUpdates(OrderedIntDoubleMapping updates) {
            throw new UnsupportedOperationException("Cannot mutate TransposeViewVector");
        }

        @Override
        public double getQuick(int index) {
            Vector v = this.rowToColumn ? this.matrix.viewColumn(index) : this.matrix.viewRow(index);
            return v == null ? 0.0 : v.getQuick(this.transposeOffset);
        }

        @Override
        public void setQuick(int index, double value) {
            Vector v;
            Vector vector = v = this.rowToColumn ? this.matrix.viewColumn(index) : this.matrix.viewRow(index);
            if (v == null) {
                v = this.newVector(this.numCols);
                if (this.rowToColumn) {
                    this.matrix.assignColumn(index, v);
                } else {
                    this.matrix.assignRow(index, v);
                }
            }
            v.setQuick(this.transposeOffset, value);
        }

        protected Vector newVector(int cardinality) {
            return new DenseVector(cardinality);
        }

        @Override
        public Vector like() {
            return new DenseVector(this.size());
        }

        public Vector like(int cardinality) {
            return new DenseVector(cardinality);
        }

        @Override
        public int getNumNondefaultElements() {
            return this.size();
        }

        @Override
        public double getLookupCost() {
            return (this.rowToColumn ? this.matrix.viewColumn(0) : this.matrix.viewRow(0)).getLookupCost();
        }

        @Override
        public double getIteratorAdvanceCost() {
            return (this.rowToColumn ? this.matrix.viewColumn(0) : this.matrix.viewRow(0)).getIteratorAdvanceCost();
        }

        @Override
        public boolean isAddConstantTime() {
            return (this.rowToColumn ? this.matrix.viewColumn(0) : this.matrix.viewRow(0)).isAddConstantTime();
        }
    }
}

