/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.math.Arrays;
import org.apache.mahout.math.Sorting;
import org.apache.mahout.math.buffer.ByteBufferConsumer;
import org.apache.mahout.math.function.ByteComparator;
import org.apache.mahout.math.function.ByteProcedure;
import org.apache.mahout.math.list.AbstractList;
import org.apache.mahout.math.list.ByteArrayList;

public abstract class AbstractByteList
extends AbstractList
implements ByteBufferConsumer,
Cloneable {
    protected int size;

    public void add(byte element) {
        this.beforeInsert(this.size, element);
    }

    public void addAllOf(AbstractByteList other) {
        this.addAllOfFromTo(other, 0, other.size() - 1);
    }

    public void addAllOfFromTo(AbstractByteList other, int from, int to) {
        this.beforeInsertAllOfFromTo(this.size, other, from, to);
    }

    @Override
    public void addAllOf(ByteArrayList other) {
        this.addAllOfFromTo(other, 0, other.size() - 1);
    }

    public void beforeInsert(int index, byte element) {
        this.beforeInsertDummies(index, 1);
        this.set(index, element);
    }

    public void beforeInsertAllOfFromTo(int index, AbstractByteList other, int from, int to) {
        int length = to - from + 1;
        this.beforeInsertDummies(index, length);
        this.replaceFromToWithFrom(index, index + length - 1, other, from);
    }

    @Override
    protected void beforeInsertDummies(int index, int length) {
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (length > 0) {
            this.ensureCapacity(this.size + length);
            this.setSizeRaw(this.size + length);
            this.replaceFromToWithFrom(index + length, this.size - 1, this, index);
        }
    }

    public int binarySearch(byte key) {
        return this.binarySearchFromTo(key, 0, this.size - 1);
    }

    public int binarySearchFromTo(byte key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = (low + high) / 2;
            byte midVal = this.get(mid);
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(byte elem) {
        return this.indexOfFromTo(elem, 0, this.size - 1) >= 0;
    }

    public void delete(byte element) {
        int index = this.indexOfFromTo(element, 0, this.size - 1);
        if (index >= 0) {
            this.remove(index);
        }
    }

    public byte[] elements() {
        byte[] myElements = new byte[this.size];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public AbstractByteList elements(byte[] elements) {
        this.clear();
        this.addAllOfFromTo(new ByteArrayList(elements), 0, elements.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object otherObj) {
        if (otherObj == null) {
            return false;
        }
        if (!(otherObj instanceof AbstractByteList)) {
            return false;
        }
        if (this == otherObj) {
            return true;
        }
        AbstractByteList other = (AbstractByteList)otherObj;
        if (this.size() != other.size()) {
            return false;
        }
        int i = this.size();
        while (--i >= 0) {
            if (this.getQuick(i) == other.getQuick(i)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int from, int to, byte val) {
        AbstractByteList.checkRangeFromTo(from, to, this.size);
        int i = from;
        while (i <= to) {
            this.setQuick(i++, val);
        }
    }

    public boolean forEach(ByteProcedure procedure) {
        int i = 0;
        while (i < this.size) {
            if (procedure.apply(this.get(i++))) continue;
            return false;
        }
        return true;
    }

    public byte get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return this.getQuick(index);
    }

    protected abstract byte getQuick(int var1);

    public int indexOf(byte element) {
        return this.indexOfFromTo(element, 0, this.size - 1);
    }

    public int indexOfFromTo(byte element, int from, int to) {
        AbstractByteList.checkRangeFromTo(from, to, this.size);
        for (int i = from; i <= to; ++i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(byte element) {
        return this.lastIndexOfFromTo(element, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(byte element, int from, int to) {
        AbstractByteList.checkRangeFromTo(from, to, this.size());
        for (int i = to; i >= from; --i) {
            if (element != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void mergeSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractByteList.checkRangeFromTo(from, to, mySize);
        byte[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void mergeSortFromTo(int from, int to, ByteComparator c) {
        int mySize = this.size();
        AbstractByteList.checkRangeFromTo(from, to, mySize);
        byte[] myElements = this.elements();
        Sorting.mergeSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public AbstractByteList partFromTo(int from, int to) {
        AbstractByteList.checkRangeFromTo(from, to, this.size);
        int length = to - from + 1;
        ByteArrayList part = new ByteArrayList(length);
        part.addAllOfFromTo(this, from, to);
        return part;
    }

    @Override
    public void quickSortFromTo(int from, int to) {
        int mySize = this.size();
        AbstractByteList.checkRangeFromTo(from, to, mySize);
        byte[] myElements = this.elements();
        java.util.Arrays.sort(myElements, from, to + 1);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public void quickSortFromTo(int from, int to, ByteComparator c) {
        int mySize = this.size();
        AbstractByteList.checkRangeFromTo(from, to, mySize);
        byte[] myElements = this.elements();
        Sorting.quickSort(myElements, from, to + 1, c);
        this.elements(myElements);
        this.setSizeRaw(mySize);
    }

    public boolean removeAll(AbstractByteList other) {
        if (other.isEmpty()) {
            return false;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) >= 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void removeFromTo(int from, int to) {
        int width;
        AbstractByteList.checkRangeFromTo(from, to, this.size);
        int numMoved = this.size - to - 1;
        if (numMoved > 0) {
            this.replaceFromToWithFrom(from, from - 1 + numMoved, this, to + 1);
        }
        if ((width = to - from + 1) > 0) {
            this.setSizeRaw(this.size - width);
        }
    }

    public void replaceFromToWithFrom(int from, int to, AbstractByteList other, int otherFrom) {
        block4: {
            int length = to - from + 1;
            if (length <= 0) break block4;
            AbstractByteList.checkRangeFromTo(from, to, this.size());
            AbstractByteList.checkRangeFromTo(otherFrom, otherFrom + length - 1, other.size());
            if (from <= otherFrom) {
                while (--length >= 0) {
                    this.setQuick(from++, other.getQuick(otherFrom++));
                }
            } else {
                int otherTo = otherFrom + length - 1;
                while (--length >= 0) {
                    this.setQuick(to--, other.getQuick(otherTo--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int from, int to, AbstractByteList other, int otherFrom, int otherTo) {
        int length;
        if (otherFrom > otherTo) {
            throw new IndexOutOfBoundsException("otherFrom: " + otherFrom + ", otherTo: " + otherTo);
        }
        if (this == other && to - from != otherTo - otherFrom) {
            this.replaceFromToWithFromTo(from, to, this.partFromTo(otherFrom, otherTo), 0, otherTo - otherFrom);
            return;
        }
        int diff = length = otherTo - otherFrom + 1;
        int theLast = from - 1;
        if (to >= from) {
            diff -= to - from + 1;
            theLast = to;
        }
        if (diff > 0) {
            this.beforeInsertDummies(theLast + 1, diff);
        } else if (diff < 0) {
            this.removeFromTo(theLast + diff, theLast - 1);
        }
        if (length > 0) {
            this.replaceFromToWithFrom(from, from + length - 1, other, otherFrom);
        }
    }

    public boolean retainAll(AbstractByteList other) {
        if (other.isEmpty()) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int limit = other.size() - 1;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            if (other.indexOfFromTo(this.getQuick(i), 0, limit) < 0) continue;
            this.setQuick(j++, this.getQuick(i));
        }
        boolean modified = j != this.size;
        this.setSize(j);
        return modified;
    }

    @Override
    public void reverse() {
        int limit = this.size() / 2;
        int j = this.size() - 1;
        int i = 0;
        while (i < limit) {
            byte tmp = this.getQuick(i);
            this.setQuick(i++, this.getQuick(j));
            this.setQuick(j--, tmp);
        }
    }

    public void set(int index, byte element) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        this.setQuick(index, element);
    }

    protected abstract void setQuick(int var1, byte var2);

    protected void setSizeRaw(int newSize) {
        this.size = newSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractByteList times(int times) {
        ByteArrayList newList = new ByteArrayList(times * this.size());
        int i = times;
        while (--i >= 0) {
            newList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return newList;
    }

    public List<Byte> toList() {
        int mySize = this.size();
        ArrayList<Byte> list = new ArrayList<Byte>(mySize);
        for (int i = 0; i < mySize; ++i) {
            list.add(this.get(i));
        }
        return list;
    }

    public byte[] toArray(byte[] values) {
        int mySize = this.size();
        byte[] myElements = values.length >= mySize ? values : new byte[mySize];
        int i = this.size;
        while (--i >= 0) {
            myElements[i] = this.getQuick(i);
        }
        return myElements;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

