/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.VarLongWritable;

public final class EntityPrefWritable
extends VarLongWritable
implements Cloneable {
    private float prefValue;

    public EntityPrefWritable() {
    }

    public EntityPrefWritable(long itemID, float prefValue) {
        super(itemID);
        this.prefValue = prefValue;
    }

    public EntityPrefWritable(EntityPrefWritable other) {
        this(other.get(), other.getPrefValue());
    }

    public long getID() {
        return this.get();
    }

    public float getPrefValue() {
        return this.prefValue;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeFloat(this.prefValue);
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.prefValue = in.readFloat();
    }

    public int hashCode() {
        return super.hashCode() ^ RandomUtils.hashFloat((float)this.prefValue);
    }

    public boolean equals(Object o) {
        if (!(o instanceof EntityPrefWritable)) {
            return false;
        }
        EntityPrefWritable other = (EntityPrefWritable)o;
        return this.get() == other.get() && this.prefValue == other.getPrefValue();
    }

    public String toString() {
        return this.get() + "\t" + this.prefValue;
    }

    public EntityPrefWritable clone() {
        return new EntityPrefWritable(this.get(), this.prefValue);
    }
}

