/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.item;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.math.Varint;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public final class VectorOrPrefWritable
implements Writable {
    private Vector vector;
    private long userID;
    private float value;

    public VectorOrPrefWritable() {
    }

    public VectorOrPrefWritable(Vector vector) {
        this.vector = vector;
    }

    public VectorOrPrefWritable(long userID, float value) {
        this.userID = userID;
        this.value = value;
    }

    public Vector getVector() {
        return this.vector;
    }

    public long getUserID() {
        return this.userID;
    }

    public float getValue() {
        return this.value;
    }

    void set(Vector vector) {
        this.vector = vector;
        this.userID = Long.MIN_VALUE;
        this.value = Float.NaN;
    }

    public void set(long userID, float value) {
        this.vector = null;
        this.userID = userID;
        this.value = value;
    }

    public void write(DataOutput out) throws IOException {
        if (this.vector == null) {
            out.writeBoolean(false);
            Varint.writeSignedVarLong((long)this.userID, (DataOutput)out);
            out.writeFloat(this.value);
        } else {
            out.writeBoolean(true);
            VectorWritable vw = new VectorWritable(this.vector);
            vw.setWritesLaxPrecision(true);
            vw.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        boolean hasVector = in.readBoolean();
        if (hasVector) {
            VectorWritable writable = new VectorWritable();
            writable.readFields(in);
            this.set(writable.get());
        } else {
            long theUserID = Varint.readSignedVarLong((DataInput)in);
            float theValue = in.readFloat();
            this.set(theUserID, theValue);
        }
    }

    public String toString() {
        return this.vector == null ? this.userID + ":" + this.value : this.vector.toString();
    }
}

