/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastMap;
import org.apache.mahout.cf.taste.impl.common.Retriever;

public final class Cache<K, V>
implements Retriever<K, V> {
    private static final Object NULL = new Object();
    private final FastMap<K, V> cache;
    private final Retriever<? super K, ? extends V> retriever;

    public Cache(Retriever<? super K, ? extends V> retriever) {
        this(retriever, Integer.MAX_VALUE);
    }

    public Cache(Retriever<? super K, ? extends V> retriever, int maxEntries) {
        Preconditions.checkArgument((retriever != null ? 1 : 0) != 0, (Object)"retriever is null");
        Preconditions.checkArgument((maxEntries >= 1 ? 1 : 0) != 0, (Object)"maxEntries must be at least 1");
        this.cache = new FastMap(11, maxEntries);
        this.retriever = retriever;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) throws TasteException {
        V value;
        FastMap<K, V> fastMap = this.cache;
        synchronized (fastMap) {
            value = this.cache.get(key);
        }
        if (value == null) {
            return this.getAndCacheValue(key);
        }
        return value == NULL ? null : (V)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        FastMap<K, V> fastMap = this.cache;
        synchronized (fastMap) {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeKeysMatching(MatchPredicate<K> predicate) {
        FastMap<K, V> fastMap = this.cache;
        synchronized (fastMap) {
            Iterator<K> it = this.cache.keySet().iterator();
            while (it.hasNext()) {
                K key = it.next();
                if (!predicate.matches(key)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueMatching(MatchPredicate<V> predicate) {
        FastMap<K, V> fastMap = this.cache;
        synchronized (fastMap) {
            Iterator<V> it = this.cache.values().iterator();
            while (it.hasNext()) {
                V value = it.next();
                if (!predicate.matches(value)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FastMap<K, V> fastMap = this.cache;
        synchronized (fastMap) {
            this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V getAndCacheValue(K key) throws TasteException {
        Object value = this.retriever.get(key);
        if (value == null) {
            value = NULL;
        }
        FastMap<K, V> fastMap = this.cache;
        synchronized (fastMap) {
            this.cache.put(key, value);
        }
        return value;
    }

    public String toString() {
        return "Cache[retriever:" + this.retriever + ']';
    }

    public static interface MatchPredicate<T> {
        public boolean matches(T var1);
    }
}

