/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;

public class RegressionResultAnalyzer {
    private List<Result> results;

    public void addInstance(double actual, double result) {
        if (this.results == null) {
            this.results = new ArrayList<Result>();
        }
        this.results.add(new Result(actual, result));
    }

    public void setInstances(double[][] results) {
        for (double[] res : results) {
            this.addInstance(res[0], res[1]);
        }
    }

    public String toString() {
        double sumActual = 0.0;
        double sumActualSquared = 0.0;
        double sumResult = 0.0;
        double sumResultSquared = 0.0;
        double sumActualResult = 0.0;
        double sumAbsolute = 0.0;
        double sumAbsoluteSquared = 0.0;
        int predictable = 0;
        int unpredictable = 0;
        for (Result res : this.results) {
            double actual = res.getActual();
            double result = res.getResult();
            if (Double.isNaN(result)) {
                ++unpredictable;
                continue;
            }
            sumActual += actual;
            sumActualSquared += actual * actual;
            sumResult += result;
            sumResultSquared += result * result;
            sumActualResult += actual * result;
            double absolute = Math.abs(actual - result);
            sumAbsolute += absolute;
            sumAbsoluteSquared += absolute * absolute;
            ++predictable;
        }
        StringBuilder returnString = new StringBuilder();
        returnString.append("=======================================================\n");
        returnString.append("Summary\n");
        returnString.append("-------------------------------------------------------\n");
        if (predictable > 0) {
            double varActual = sumActualSquared - sumActual * sumActual / (double)predictable;
            double varResult = sumResultSquared - sumResult * sumResult / (double)predictable;
            double varCo = sumActualResult - sumActual * sumResult / (double)predictable;
            double correlation = varActual * varResult <= 0.0 ? 0.0 : varCo / Math.sqrt(varActual * varResult);
            Locale.setDefault(Locale.US);
            DecimalFormat decimalFormatter = new DecimalFormat("0.####");
            returnString.append(StringUtils.rightPad((String)"Correlation coefficient", (int)40)).append(": ").append(StringUtils.leftPad((String)decimalFormatter.format(correlation), (int)10)).append('\n');
            returnString.append(StringUtils.rightPad((String)"Mean absolute error", (int)40)).append(": ").append(StringUtils.leftPad((String)decimalFormatter.format(sumAbsolute / (double)predictable), (int)10)).append('\n');
            returnString.append(StringUtils.rightPad((String)"Root mean squared error", (int)40)).append(": ").append(StringUtils.leftPad((String)decimalFormatter.format(Math.sqrt(sumAbsoluteSquared / (double)predictable)), (int)10)).append('\n');
        }
        returnString.append(StringUtils.rightPad((String)"Predictable Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(predictable), (int)10)).append('\n');
        returnString.append(StringUtils.rightPad((String)"Unpredictable Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(unpredictable), (int)10)).append('\n');
        returnString.append(StringUtils.rightPad((String)"Total Regressed Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(this.results.size()), (int)10)).append('\n');
        returnString.append('\n');
        return returnString.toString();
    }

    private static class Result {
        private final double actual;
        private final double result;

        Result(double actual, double result) {
            this.actual = actual;
            this.result = result;
        }

        double getActual() {
            return this.actual;
        }

        double getResult() {
            return this.result;
        }
    }
}

