/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier;

import java.text.DecimalFormat;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;
import org.apache.mahout.classifier.ClassifierResult;
import org.apache.mahout.classifier.ConfusionMatrix;
import org.apache.mahout.math.stats.OnlineSummarizer;

public class ResultAnalyzer {
    private final ConfusionMatrix confusionMatrix;
    private final OnlineSummarizer summarizer;
    private boolean hasLL;
    private int correctlyClassified;
    private int incorrectlyClassified;

    public ResultAnalyzer(Collection<String> labelSet, String defaultLabel) {
        this.confusionMatrix = new ConfusionMatrix(labelSet, defaultLabel);
        this.summarizer = new OnlineSummarizer();
    }

    public ConfusionMatrix getConfusionMatrix() {
        return this.confusionMatrix;
    }

    public boolean addInstance(String correctLabel, ClassifierResult classifiedResult) {
        boolean result = correctLabel.equals(classifiedResult.getLabel());
        if (result) {
            ++this.correctlyClassified;
        } else {
            ++this.incorrectlyClassified;
        }
        this.confusionMatrix.addInstance(correctLabel, classifiedResult);
        if (classifiedResult.getLogLikelihood() != Double.MAX_VALUE) {
            this.summarizer.add(classifiedResult.getLogLikelihood());
            this.hasLL = true;
        }
        return result;
    }

    public String toString() {
        StringBuilder returnString = new StringBuilder();
        returnString.append('\n');
        returnString.append("=======================================================\n");
        returnString.append("Summary\n");
        returnString.append("-------------------------------------------------------\n");
        int totalClassified = this.correctlyClassified + this.incorrectlyClassified;
        double percentageCorrect = 100.0 * (double)this.correctlyClassified / (double)totalClassified;
        double percentageIncorrect = 100.0 * (double)this.incorrectlyClassified / (double)totalClassified;
        DecimalFormat decimalFormatter = new DecimalFormat("0.####");
        returnString.append(StringUtils.rightPad((String)"Correctly Classified Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(this.correctlyClassified), (int)10)).append('\t').append(StringUtils.leftPad((String)decimalFormatter.format(percentageCorrect), (int)10)).append("%\n");
        returnString.append(StringUtils.rightPad((String)"Incorrectly Classified Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(this.incorrectlyClassified), (int)10)).append('\t').append(StringUtils.leftPad((String)decimalFormatter.format(percentageIncorrect), (int)10)).append("%\n");
        returnString.append(StringUtils.rightPad((String)"Total Classified Instances", (int)40)).append(": ").append(StringUtils.leftPad((String)Integer.toString(totalClassified), (int)10)).append('\n');
        returnString.append('\n');
        returnString.append(this.confusionMatrix);
        returnString.append("=======================================================\n");
        returnString.append("Statistics\n");
        returnString.append("-------------------------------------------------------\n");
        RunningAverageAndStdDev normStats = this.confusionMatrix.getNormalizedStats();
        returnString.append(StringUtils.rightPad((String)"Kappa", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(this.confusionMatrix.getKappa()), (int)10)).append('\n');
        returnString.append(StringUtils.rightPad((String)"Accuracy", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(this.confusionMatrix.getAccuracy()), (int)10)).append("%\n");
        returnString.append(StringUtils.rightPad((String)"Reliability", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(normStats.getAverage() * 100.00000001), (int)10)).append("%\n");
        returnString.append(StringUtils.rightPad((String)"Reliability (standard deviation)", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(normStats.getStandardDeviation()), (int)10)).append('\n');
        returnString.append(StringUtils.rightPad((String)"Weighted precision", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(this.confusionMatrix.getWeightedPrecision()), (int)10)).append('\n');
        returnString.append(StringUtils.rightPad((String)"Weighted recall", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(this.confusionMatrix.getWeightedRecall()), (int)10)).append('\n');
        returnString.append(StringUtils.rightPad((String)"Weighted F1 score", (int)40)).append(StringUtils.leftPad((String)decimalFormatter.format(this.confusionMatrix.getWeightedF1score()), (int)10)).append('\n');
        if (this.hasLL) {
            returnString.append(StringUtils.rightPad((String)"Log-likelihood", (int)30)).append("mean      : ").append(StringUtils.leftPad((String)decimalFormatter.format(this.summarizer.getMean()), (int)10)).append('\n');
            returnString.append(StringUtils.rightPad((String)"", (int)30)).append(StringUtils.rightPad((String)"25%-ile   : ", (int)10)).append(StringUtils.leftPad((String)decimalFormatter.format(this.summarizer.getQuartile(1)), (int)10)).append('\n');
            returnString.append(StringUtils.rightPad((String)"", (int)30)).append(StringUtils.rightPad((String)"75%-ile   : ", (int)10)).append(StringUtils.leftPad((String)decimalFormatter.format(this.summarizer.getQuartile(3)), (int)10)).append('\n');
        }
        return returnString.toString();
    }
}

