/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.eval;

import java.util.Arrays;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OrderBasedRecommenderEvaluator {
    private static final Logger log = LoggerFactory.getLogger(OrderBasedRecommenderEvaluator.class);

    private OrderBasedRecommenderEvaluator() {
    }

    public static void evaluate(Recommender recommender1, Recommender recommender2, int samples, RunningAverage tracker, String tag) throws TasteException {
        OrderBasedRecommenderEvaluator.printHeader();
        LongPrimitiveIterator users = recommender1.getDataModel().getUserIDs();
        while (users.hasNext()) {
            long userID = users.nextLong();
            List<RecommendedItem> recs1 = recommender1.recommend(userID, samples);
            List<RecommendedItem> recs2 = recommender2.recommend(userID, samples);
            FastIDSet commonSet = new FastIDSet();
            long maxItemID = OrderBasedRecommenderEvaluator.setBits(commonSet, recs1, samples);
            FastIDSet otherSet = new FastIDSet();
            maxItemID = Math.max(maxItemID, OrderBasedRecommenderEvaluator.setBits(otherSet, recs2, samples));
            int max = OrderBasedRecommenderEvaluator.mask(commonSet, otherSet, maxItemID);
            if ((max = Math.min(max, samples)) < 2) continue;
            Long[] items1 = OrderBasedRecommenderEvaluator.getCommonItems(commonSet, recs1, max);
            Long[] items2 = OrderBasedRecommenderEvaluator.getCommonItems(commonSet, recs2, max);
            double variance = OrderBasedRecommenderEvaluator.scoreCommonSubset(tag, userID, samples, max, items1, items2);
            tracker.addDatum(variance);
        }
    }

    public static void evaluate(Recommender recommender, DataModel model, int samples, RunningAverage tracker, String tag) throws TasteException {
        OrderBasedRecommenderEvaluator.printHeader();
        LongPrimitiveIterator users = recommender.getDataModel().getUserIDs();
        while (users.hasNext()) {
            long userID = users.nextLong();
            List<RecommendedItem> recs1 = recommender.recommend(userID, model.getNumItems());
            PreferenceArray prefs2 = model.getPreferencesFromUser(userID);
            prefs2.sortByValueReversed();
            FastIDSet commonSet = new FastIDSet();
            long maxItemID = OrderBasedRecommenderEvaluator.setBits(commonSet, recs1, samples);
            FastIDSet otherSet = new FastIDSet();
            maxItemID = Math.max(maxItemID, OrderBasedRecommenderEvaluator.setBits(otherSet, prefs2, samples));
            int max = OrderBasedRecommenderEvaluator.mask(commonSet, otherSet, maxItemID);
            max = Math.min(max, samples);
            if (max < 2) continue;
            Long[] items1 = OrderBasedRecommenderEvaluator.getCommonItems(commonSet, recs1, max);
            Long[] items2 = OrderBasedRecommenderEvaluator.getCommonItems(commonSet, prefs2, max);
            double variance = OrderBasedRecommenderEvaluator.scoreCommonSubset(tag, userID, samples, max, items1, items2);
            tracker.addDatum(variance);
        }
    }

    public static void evaluate(DataModel model1, DataModel model2, int samples, RunningAverage tracker, String tag) throws TasteException {
        OrderBasedRecommenderEvaluator.printHeader();
        LongPrimitiveIterator users = model1.getUserIDs();
        while (users.hasNext()) {
            long userID = users.nextLong();
            PreferenceArray prefs1 = model1.getPreferencesFromUser(userID);
            PreferenceArray prefs2 = model2.getPreferencesFromUser(userID);
            prefs1.sortByValueReversed();
            prefs2.sortByValueReversed();
            FastIDSet commonSet = new FastIDSet();
            long maxItemID = OrderBasedRecommenderEvaluator.setBits(commonSet, prefs1, samples);
            FastIDSet otherSet = new FastIDSet();
            maxItemID = Math.max(maxItemID, OrderBasedRecommenderEvaluator.setBits(otherSet, prefs2, samples));
            int max = OrderBasedRecommenderEvaluator.mask(commonSet, otherSet, maxItemID);
            max = Math.min(max, samples);
            if (max < 2) continue;
            Long[] items1 = OrderBasedRecommenderEvaluator.getCommonItems(commonSet, prefs1, max);
            Long[] items2 = OrderBasedRecommenderEvaluator.getCommonItems(commonSet, prefs2, max);
            double variance = OrderBasedRecommenderEvaluator.scoreCommonSubset(tag, userID, samples, max, items1, items2);
            tracker.addDatum(variance);
        }
    }

    private static int mask(FastIDSet commonSet, FastIDSet otherSet, long maxItemID) {
        int count = 0;
        int i = 0;
        while ((long)i <= maxItemID) {
            if (commonSet.contains(i)) {
                if (otherSet.contains(i)) {
                    ++count;
                } else {
                    commonSet.remove(i);
                }
            }
            ++i;
        }
        return count;
    }

    private static Long[] getCommonItems(FastIDSet commonSet, Iterable<RecommendedItem> recs, int max) {
        Long[] commonItems = new Long[max];
        int index = 0;
        for (RecommendedItem rec : recs) {
            Long item = rec.getItemID();
            if (commonSet.contains(item)) {
                commonItems[index++] = item;
            }
            if (index != max) continue;
            break;
        }
        return commonItems;
    }

    private static Long[] getCommonItems(FastIDSet commonSet, PreferenceArray prefs1, int max) {
        Long[] commonItems = new Long[max];
        int index = 0;
        for (int i = 0; i < prefs1.length(); ++i) {
            Long item = prefs1.getItemID(i);
            if (commonSet.contains(item)) {
                commonItems[index++] = item;
            }
            if (index == max) break;
        }
        return commonItems;
    }

    private static long setBits(FastIDSet modelSet, List<RecommendedItem> items, int max) {
        long maxItem = -1L;
        for (int i = 0; i < items.size() && i < max; ++i) {
            long itemID = items.get(i).getItemID();
            modelSet.add(itemID);
            if (itemID <= maxItem) continue;
            maxItem = itemID;
        }
        return maxItem;
    }

    private static long setBits(FastIDSet modelSet, PreferenceArray prefs, int max) {
        long maxItem = -1L;
        for (int i = 0; i < prefs.length() && i < max; ++i) {
            long itemID = prefs.getItemID(i);
            modelSet.add(itemID);
            if (itemID <= maxItem) continue;
            maxItem = itemID;
        }
        return maxItem;
    }

    private static void printHeader() {
        log.info("tag,user,samples,common,hamming,bubble,rank,normal,score");
    }

    private static double scoreCommonSubset(String tag, long userID, int samples, int subset, Long[] itemsL, Long[] itemsR) {
        int[] vectorZ = new int[subset];
        int[] vectorZabs = new int[subset];
        long bubble = OrderBasedRecommenderEvaluator.sort(itemsL, itemsR);
        int hamming = OrderBasedRecommenderEvaluator.slidingWindowHamming(itemsR, itemsL);
        if (hamming > samples) {
            throw new IllegalStateException();
        }
        OrderBasedRecommenderEvaluator.getVectorZ(itemsR, itemsL, vectorZ, vectorZabs);
        double normalW = OrderBasedRecommenderEvaluator.normalWilcoxon(vectorZ, vectorZabs);
        double meanRank = OrderBasedRecommenderEvaluator.getMeanRank(vectorZabs);
        double variance = Math.sqrt(meanRank);
        log.info("{},{},{},{},{},{},{},{},{}", new Object[]{tag, userID, samples, subset, hamming, bubble, meanRank, normalW, variance});
        return variance;
    }

    private static int slidingWindowHamming(Long[] itemsR, Long[] itemsL) {
        int count = 0;
        int samples = itemsR.length;
        if (itemsR[0].equals(itemsL[0]) || itemsR[0].equals(itemsL[1])) {
            ++count;
        }
        for (int i = 1; i < samples - 1; ++i) {
            long itemID = itemsL[i];
            if (itemsR[i] != itemID && itemsR[i - 1] != itemID && itemsR[i + 1] != itemID) continue;
            ++count;
        }
        if (itemsR[samples - 1].equals(itemsL[samples - 1]) || itemsR[samples - 1].equals(itemsL[samples - 2])) {
            ++count;
        }
        return count;
    }

    static double normalWilcoxon(int[] vectorZ, int[] vectorZabs) {
        int nitems = vectorZ.length;
        double[] ranks = new double[nitems];
        double[] ranksAbs = new double[nitems];
        OrderBasedRecommenderEvaluator.wilcoxonRanks(vectorZ, vectorZabs, ranks, ranksAbs);
        return Math.min(OrderBasedRecommenderEvaluator.getMeanWplus(ranks), OrderBasedRecommenderEvaluator.getMeanWminus(ranks));
    }

    private static void getVectorZ(Long[] itemsR, Long[] itemsL, int[] vectorZ, int[] vectorZabs) {
        int nitems = itemsR.length;
        int bottom = 0;
        int top = nitems - 1;
        block0: for (int i = 0; i < nitems; ++i) {
            long itemID = itemsR[i];
            for (int j = bottom; j <= top; ++j) {
                long test;
                if (itemsL[j] == null || itemID != (test = itemsL[j].longValue())) continue;
                vectorZ[i] = i - j;
                vectorZabs[i] = Math.abs(i - j);
                if (j == bottom) {
                    ++bottom;
                    continue block0;
                }
                if (j == top) {
                    --top;
                    continue block0;
                }
                itemsL[j] = null;
                continue block0;
            }
        }
    }

    private static void wilcoxonRanks(int[] vectorZ, int[] vectorZabs, double[] ranks, double[] ranksAbs) {
        int zeros;
        int nitems = vectorZ.length;
        int[] sorted = (int[])vectorZabs.clone();
        Arrays.sort(sorted);
        for (zeros = 0; zeros < nitems && sorted[zeros] <= 0; ++zeros) {
        }
        for (int i = 0; i < nitems; ++i) {
            double rank = 0.0;
            int count = 0;
            int score = vectorZabs[i];
            for (int j = 0; j < nitems; ++j) {
                if (score == sorted[j]) {
                    rank += (double)(j + 1 - zeros);
                    ++count;
                    continue;
                }
                if (score < sorted[j]) break;
            }
            if (vectorZ[i] == 0) continue;
            ranks[i] = rank / (double)count * (double)(vectorZ[i] < 0 ? -1 : 1);
            ranksAbs[i] = Math.abs(ranks[i]);
        }
    }

    private static double getMeanRank(int[] ranks) {
        int nitems = ranks.length;
        double sum = 0.0;
        for (int rank : ranks) {
            sum += (double)rank;
        }
        return sum / (double)nitems;
    }

    private static double getMeanWplus(double[] ranks) {
        int nitems = ranks.length;
        double sum = 0.0;
        for (double rank : ranks) {
            if (!(rank > 0.0)) continue;
            sum += rank;
        }
        return sum / (double)nitems;
    }

    private static double getMeanWminus(double[] ranks) {
        int nitems = ranks.length;
        double sum = 0.0;
        for (double rank : ranks) {
            if (!(rank < 0.0)) continue;
            sum -= rank;
        }
        return sum / (double)nitems;
    }

    static long sort(Long[] itemsL, Long[] itemsR) {
        int length = itemsL.length;
        if (length < 2) {
            return 0L;
        }
        if (length == 2) {
            return itemsL[0].longValue() == itemsR[0].longValue() ? 0L : 1L;
        }
        long[] reference = new long[length];
        long[] sortable = new long[length];
        for (int i = 0; i < length; ++i) {
            reference[i] = itemsL[i];
            sortable[i] = itemsR[i];
        }
        int sorted = 0;
        long swaps = 0L;
        while (sorted < length - 1) {
            while (length > 0 && reference[length - 1] == sortable[length - 1]) {
                --length;
            }
            if (length == 0) break;
            if (reference[sorted] == sortable[sorted]) {
                ++sorted;
                continue;
            }
            for (int j = sorted; j < length - 1; ++j) {
                int jump = 1;
                if (reference[j] == sortable[j]) {
                    while (j + jump < length && reference[j + jump] == sortable[j + jump]) {
                        ++jump;
                    }
                }
                if (j + jump >= length || reference[j] == sortable[j] && reference[j + jump] == sortable[j + jump]) continue;
                long tmp = sortable[j];
                sortable[j] = sortable[j + 1];
                sortable[j + 1] = tmp;
                ++swaps;
            }
        }
        return swaps;
    }
}

