/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.builder;

import java.util.Random;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.data.conditions.Condition;
import org.apache.mahout.classifier.df.node.CategoricalNode;
import org.apache.mahout.classifier.df.node.Leaf;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.classifier.df.node.NumericalNode;
import org.apache.mahout.classifier.df.split.IgSplit;
import org.apache.mahout.classifier.df.split.OptIgSplit;
import org.apache.mahout.classifier.df.split.Split;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultTreeBuilder
implements TreeBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultTreeBuilder.class);
    private static final int[] NO_ATTRIBUTES = new int[0];
    private boolean[] selected;
    private int m = 1;
    private final IgSplit igSplit = new OptIgSplit();

    public void setM(int m) {
        this.m = m;
    }

    @Override
    public Node build(Random rng, Data data) {
        Node childNode;
        if (this.selected == null) {
            this.selected = new boolean[data.getDataset().nbAttributes()];
            this.selected[data.getDataset().getLabelId()] = true;
        }
        if (data.isEmpty()) {
            return new Leaf(-1.0);
        }
        if (this.isIdentical(data)) {
            return new Leaf(data.majorityLabel(rng));
        }
        if (data.identicalLabel()) {
            return new Leaf(data.getDataset().getLabel(data.get(0)));
        }
        int[] attributes = DefaultTreeBuilder.randomAttributes(rng, this.selected, this.m);
        if (attributes == null || attributes.length == 0) {
            return new Leaf(data.majorityLabel(rng));
        }
        Split best = null;
        for (int attr : attributes) {
            Split split = this.igSplit.computeSplit(data, attr);
            if (best != null && !(best.getIg() < split.getIg())) continue;
            best = split;
        }
        boolean alreadySelected = this.selected[best.getAttr()];
        if (alreadySelected) {
            log.warn("attribute {} already selected in a parent node", (Object)best.getAttr());
        }
        if (data.getDataset().isNumerical(best.getAttr())) {
            boolean[] temp = null;
            Data loSubset = data.subset(Condition.lesser(best.getAttr(), best.getSplit()));
            Data hiSubset = data.subset(Condition.greaterOrEquals(best.getAttr(), best.getSplit()));
            if (loSubset.isEmpty() || hiSubset.isEmpty()) {
                this.selected[best.getAttr()] = true;
            } else {
                temp = this.selected;
                this.selected = DefaultTreeBuilder.cloneCategoricalAttributes(data.getDataset(), this.selected);
            }
            Node loChild = this.build(rng, loSubset);
            Node hiChild = this.build(rng, hiSubset);
            if (temp != null) {
                this.selected = temp;
            } else {
                this.selected[best.getAttr()] = alreadySelected;
            }
            childNode = new NumericalNode(best.getAttr(), best.getSplit(), loChild, hiChild);
        } else {
            this.selected[best.getAttr()] = true;
            double[] values = data.values(best.getAttr());
            Node[] children = new Node[values.length];
            for (int index = 0; index < values.length; ++index) {
                Data subset = data.subset(Condition.equals(best.getAttr(), values[index]));
                children[index] = this.build(rng, subset);
            }
            this.selected[best.getAttr()] = alreadySelected;
            childNode = new CategoricalNode(best.getAttr(), values, children);
        }
        return childNode;
    }

    private boolean isIdentical(Data data) {
        if (data.isEmpty()) {
            return true;
        }
        Instance instance = data.get(0);
        for (int attr = 0; attr < this.selected.length; ++attr) {
            if (this.selected[attr]) continue;
            for (int index = 1; index < data.size(); ++index) {
                if (data.get(index).get(attr) == instance.get(attr)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean[] cloneCategoricalAttributes(Dataset dataset, boolean[] selected) {
        boolean[] cloned = new boolean[selected.length];
        for (int i = 0; i < selected.length; ++i) {
            cloned[i] = !dataset.isNumerical(i) && selected[i];
        }
        return cloned;
    }

    protected static int[] randomAttributes(Random rng, boolean[] selected, int m) {
        int index;
        int[] result;
        int nbNonSelected = 0;
        for (boolean sel : selected) {
            if (sel) continue;
            ++nbNonSelected;
        }
        if (nbNonSelected == 0) {
            log.warn("All attributes are selected !");
            return NO_ATTRIBUTES;
        }
        if (nbNonSelected <= m) {
            result = new int[nbNonSelected];
            index = 0;
            for (int attr = 0; attr < selected.length; ++attr) {
                if (selected[attr]) continue;
                result[index++] = attr;
            }
        } else {
            result = new int[m];
            for (index = 0; index < m; ++index) {
                int rind;
                while (selected[rind = rng.nextInt(selected.length)]) {
                }
                result[index] = rind;
                selected[rind] = true;
            }
            for (int attr : result) {
                selected[attr] = false;
            }
        }
        return result;
    }
}

