/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.naivebayes;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.classifier.naivebayes.NaiveBayesModel;
import org.apache.mahout.classifier.naivebayes.training.ThetaMapper;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class BayesUtils {
    private static final Pattern SLASH = Pattern.compile("/");

    private BayesUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public static NaiveBayesModel readModelFromDir(Path base, Configuration conf) {
        void var7_13;
        float alphaI = conf.getFloat(ThetaMapper.ALPHA_I, 1.0f);
        boolean isComplementary = conf.getBoolean("COMPLEMENTARY_MODEL", true);
        Vector scoresPerLabel = null;
        Vector scoresPerFeature = null;
        for (Pair pair : new SequenceFileDirIterable(new Path(base, "weights"), PathType.LIST, PathFilters.partFilter(), conf)) {
            String string = ((Text)pair.getFirst()).toString();
            VectorWritable value = (VectorWritable)pair.getSecond();
            if (string.equals("__SPF")) {
                scoresPerFeature = value.get();
                continue;
            }
            if (!string.equals("__SPL")) continue;
            scoresPerLabel = value.get();
        }
        Preconditions.checkNotNull(scoresPerFeature);
        Preconditions.checkNotNull(scoresPerLabel);
        SparseMatrix scoresPerLabelAndFeature = new SparseMatrix(scoresPerLabel.size(), scoresPerFeature.size());
        for (Pair pair : new SequenceFileDirIterable(new Path(base, "summedObservations"), PathType.LIST, PathFilters.partFilter(), conf)) {
            scoresPerLabelAndFeature.assignRow(((IntWritable)pair.getFirst()).get(), ((VectorWritable)pair.getSecond()).get());
        }
        Object var7_9 = null;
        if (isComplementary) {
            void var7_11;
            Vector vector = scoresPerLabel.like();
            for (Pair entry : new SequenceFileDirIterable(new Path(base, "thetas"), PathType.LIST, PathFilters.partFilter(), conf)) {
                if (!((Text)entry.getFirst()).toString().equals("_LTN")) continue;
                Vector vector2 = ((VectorWritable)entry.getSecond()).get();
            }
            Preconditions.checkNotNull((Object)var7_11);
        }
        return new NaiveBayesModel((Matrix)scoresPerLabelAndFeature, scoresPerFeature, scoresPerLabel, (Vector)var7_13, alphaI, isComplementary);
    }

    public static int writeLabelIndex(Configuration conf, Iterable<String> labels, Path indexPath) throws IOException {
        FileSystem fs = FileSystem.get((URI)indexPath.toUri(), (Configuration)conf);
        int i = 0;
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)fs.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)indexPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(IntWritable.class)});){
            for (String label : labels) {
                writer.append((Writable)new Text(label), (Writable)new IntWritable(i++));
            }
        }
        return i;
    }

    public static int writeLabelIndex(Configuration conf, Path indexPath, Iterable<Pair<Text, IntWritable>> labels) throws IOException {
        FileSystem fs = FileSystem.get((URI)indexPath.toUri(), (Configuration)conf);
        HashSet<String> seen = new HashSet<String>();
        int i = 0;
        try (SequenceFile.Writer writer = SequenceFile.createWriter((Configuration)fs.getConf(), (SequenceFile.Writer.Option[])new SequenceFile.Writer.Option[]{SequenceFile.Writer.file((Path)indexPath), SequenceFile.Writer.keyClass(Text.class), SequenceFile.Writer.valueClass(IntWritable.class)});){
            for (Pair<Text, IntWritable> label : labels) {
                String theLabel = SLASH.split(label.getFirst().toString())[1];
                if (seen.contains(theLabel)) continue;
                writer.append((Writable)new Text(theLabel), (Writable)new IntWritable(i++));
                seen.add(theLabel);
            }
        }
        return i;
    }

    public static Map<Integer, String> readLabelIndex(Configuration conf, Path indexPath) {
        HashMap<Integer, String> labelMap = new HashMap<Integer, String>();
        for (Pair pair : new SequenceFileIterable(indexPath, true, conf)) {
            labelMap.put(((IntWritable)pair.getSecond()).get(), ((Text)pair.getFirst()).toString());
        }
        return labelMap;
    }

    public static OpenObjectIntHashMap<String> readIndexFromCache(Configuration conf) throws IOException {
        OpenObjectIntHashMap index = new OpenObjectIntHashMap();
        for (Pair entry : new SequenceFileIterable(HadoopUtil.getSingleCachedFile(conf), conf)) {
            index.put((Object)((Writable)entry.getFirst()).toString(), ((IntWritable)entry.getSecond()).get());
        }
        return index;
    }

    public static Map<String, Vector> readScoresFromCache(Configuration conf) throws IOException {
        HashMap<String, Vector> sumVectors = new HashMap<String, Vector>();
        for (Pair entry : new SequenceFileDirIterable(HadoopUtil.getSingleCachedFile(conf), PathType.LIST, PathFilters.partFilter(), conf)) {
            sumVectors.put(((Text)entry.getFirst()).toString(), ((VectorWritable)entry.getSecond()).get());
        }
        return sumVectors;
    }
}

