/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.lucene;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.ClassUtils;

public final class AnalyzerUtils {
    private AnalyzerUtils() {
    }

    public static Analyzer createAnalyzer(String analyzerClassName) throws ClassNotFoundException {
        return AnalyzerUtils.createAnalyzer(analyzerClassName, Version.LUCENE_5_5_2);
    }

    public static Analyzer createAnalyzer(String analyzerClassName, Version version) throws ClassNotFoundException {
        Class<Analyzer> analyzerClass = Class.forName(analyzerClassName).asSubclass(Analyzer.class);
        return AnalyzerUtils.createAnalyzer(analyzerClass, version);
    }

    public static Analyzer createAnalyzer(Class<? extends Analyzer> analyzerClass) {
        return AnalyzerUtils.createAnalyzer(analyzerClass, Version.LUCENE_5_5_2);
    }

    public static Analyzer createAnalyzer(Class<? extends Analyzer> analyzerClass, Version version) {
        try {
            return ClassUtils.instantiateAs(analyzerClass, Analyzer.class, new Class[]{Version.class}, new Object[]{version});
        }
        catch (IllegalStateException e) {
            return ClassUtils.instantiateAs(analyzerClass, Analyzer.class);
        }
    }
}

