/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.driver;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.util.ProgramDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MahoutDriver {
    private static final Logger log = LoggerFactory.getLogger(MahoutDriver.class);

    private MahoutDriver() {
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Throwable {
        Properties mainClasses = MahoutDriver.loadProperties("driver.classes.props");
        if (mainClasses == null) {
            mainClasses = MahoutDriver.loadProperties("driver.classes.default.props");
        }
        if (mainClasses == null) {
            throw new IOException("Can't load any properties file?");
        }
        boolean foundShortName = false;
        ProgramDriver programDriver = new ProgramDriver();
        for (Object key : mainClasses.keySet()) {
            String keyString = (String)key;
            if (args.length > 0 && MahoutDriver.shortName(mainClasses.getProperty(keyString)).equals(args[0])) {
                foundShortName = true;
            }
            if (args.length > 0 && keyString.equalsIgnoreCase(args[0]) && MahoutDriver.isDeprecated(mainClasses, keyString)) {
                log.error(MahoutDriver.desc(mainClasses.getProperty(keyString)));
                return;
            }
            if (MahoutDriver.isDeprecated(mainClasses, keyString)) continue;
            MahoutDriver.addClass(programDriver, keyString, mainClasses.getProperty(keyString));
        }
        if (args.length < 1 || args[0] == null || "-h".equals(args[0]) || "--help".equals(args[0])) {
            programDriver.driver(args);
            return;
        }
        String progName = args[0];
        if (!foundShortName) {
            MahoutDriver.addClass(programDriver, progName, progName);
        }
        MahoutDriver.shift(args);
        Properties mainProps = MahoutDriver.loadProperties(progName + ".props");
        if (mainProps == null) {
            log.warn("No {}.props found on classpath, will use command-line arguments only", (Object)progName);
            mainProps = new Properties();
        }
        HashMap<Object, String[]> argMap = new HashMap<Object, String[]>();
        int i = 0;
        while (i < args.length && args[i] != null) {
            void var9_9;
            ArrayList argValues = new ArrayList();
            String string = args[i];
            ++i;
            if (string.startsWith("-D")) {
                String[] stringArray = string.split("=");
                String string2 = stringArray[0];
                if (stringArray.length == 2) {
                    argValues.add(stringArray[1]);
                }
            } else {
                while (i < args.length && args[i] != null && !args[i].startsWith("-")) {
                    argValues.add(args[i]);
                    ++i;
                }
            }
            argMap.put(var9_9, argValues.toArray(new String[argValues.size()]));
        }
        for (String string : mainProps.stringPropertyNames()) {
            String longArg;
            String[] stringArray = string.split("\\|");
            String shortArg = '-' + stringArray[0].trim();
            String string3 = longArg = stringArray.length < 2 ? null : "--" + stringArray[1].trim();
            if (argMap.containsKey(shortArg) || longArg != null && argMap.containsKey(longArg)) continue;
            argMap.put(longArg, new String[]{mainProps.getProperty(string)});
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add(progName);
        for (Map.Entry entry : argMap.entrySet()) {
            String arg = (String)entry.getKey();
            if (arg.startsWith("-D")) {
                String[] argValues = (String[])entry.getValue();
                if (argValues.length > 0 && !argValues[0].trim().isEmpty()) {
                    arg = arg + '=' + argValues[0].trim();
                }
                argsList.add(1, arg);
                continue;
            }
            argsList.add(arg);
            for (String string : Arrays.asList((Object[])argMap.get(arg))) {
                if (string.isEmpty()) continue;
                argsList.add(string);
            }
        }
        long l = System.currentTimeMillis();
        programDriver.driver(argsList.toArray(new String[argsList.size()]));
        if (log.isInfoEnabled()) {
            log.info("Program took {} ms (Minutes: {})", (Object)(System.currentTimeMillis() - l), (Object)((double)(System.currentTimeMillis() - l) / 60000.0));
        }
    }

    private static boolean isDeprecated(Properties mainClasses, String keyString) {
        return "deprecated".equalsIgnoreCase(MahoutDriver.shortName(mainClasses.getProperty(keyString)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String resource) throws IOException {
        InputStream propsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
        if (propsStream != null) {
            try {
                Properties properties = new Properties();
                properties.load(propsStream);
                Properties properties2 = properties;
                return properties2;
            }
            finally {
                Closeables.close((Closeable)propsStream, (boolean)true);
            }
        }
        return null;
    }

    private static String[] shift(String[] args) {
        System.arraycopy(args, 1, args, 0, args.length - 1);
        args[args.length - 1] = null;
        return args;
    }

    private static String shortName(String valueString) {
        return valueString.contains(":") ? valueString.substring(0, valueString.indexOf(58)).trim() : valueString;
    }

    private static String desc(String valueString) {
        return valueString.contains(":") ? valueString.substring(valueString.indexOf(58)).trim() : valueString;
    }

    private static void addClass(ProgramDriver driver, String classString, String descString) {
        try {
            Class<?> clazz = Class.forName(classString);
            driver.addClass(MahoutDriver.shortName(descString), clazz, MahoutDriver.desc(descString));
        }
        catch (Throwable t) {
            log.warn("Unable to add class: {}", (Object)classString, (Object)t);
        }
    }
}

