/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class DenseBlockWritable
implements Writable {
    private double[][] block;

    public void setBlock(double[][] block) {
        this.block = block;
    }

    public double[][] getBlock() {
        return this.block;
    }

    public void readFields(DataInput in) throws IOException {
        int m = in.readInt();
        int n = in.readInt();
        if (this.block == null) {
            this.block = new double[m][0];
        } else if (this.block.length != m) {
            this.block = (double[][])Arrays.copyOf(this.block, m);
        }
        for (int i = 0; i < m; ++i) {
            if (this.block[i] == null || this.block[i].length != n) {
                this.block[i] = new double[n];
            }
            for (int j = 0; j < n; ++j) {
                this.block[i][j] = in.readDouble();
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        int m = this.block.length;
        int n = this.block.length == 0 ? 0 : this.block[0].length;
        out.writeInt(m);
        out.writeInt(n);
        for (double[] aBlock : this.block) {
            for (int j = 0; j < n; ++j) {
                out.writeDouble(aBlock[j]);
            }
        }
    }
}

