/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.mahout.math.map.OpenIntIntHashMap;
import org.apache.mahout.vectorizer.encoders.StaticWordValueEncoder;

public class CachingStaticWordValueEncoder
extends StaticWordValueEncoder {
    private final int dataSize;
    private OpenIntIntHashMap[] caches;

    public CachingStaticWordValueEncoder(String name, int dataSize) {
        super(name);
        this.dataSize = dataSize;
        this.initCaches();
    }

    private void initCaches() {
        this.caches = new OpenIntIntHashMap[this.getProbes()];
        for (int probe = 0; probe < this.getProbes(); ++probe) {
            this.caches[probe] = new OpenIntIntHashMap();
        }
    }

    OpenIntIntHashMap[] getCaches() {
        return this.caches;
    }

    @Override
    public void setProbes(int probes) {
        super.setProbes(probes);
        this.initCaches();
    }

    @Override
    protected int hashForProbe(byte[] originalForm, int dataSize, String name, int probe) {
        Preconditions.checkArgument((dataSize == this.dataSize ? 1 : 0) != 0, (Object)("dataSize argument [" + dataSize + "] does not match expected dataSize [" + this.dataSize + ']'));
        int originalHashcode = Arrays.hashCode(originalForm);
        if (this.caches[probe].containsKey(originalHashcode)) {
            return this.caches[probe].get(originalHashcode);
        }
        int hash = super.hashForProbe(originalForm, dataSize, name, probe);
        this.caches[probe].put(originalHashcode, hash);
        return hash;
    }
}

